/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import com.jhlabs.image.BumpFilter;
import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.GainFilter;
import com.jhlabs.image.HSBAdjustFilter;
import com.jhlabs.image.QuantizeFilter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jemu.core.Util;
import jemu.settings.DSettings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.JEMU;
import jemu.ui.Switches;
import jemu.ui.paint.CPCize;
import jemu.ui.paint.DitherFilter;
import jemu.ui.paint.ImageFileView;
import jemu.ui.paint.ImageFilter;
import jemu.ui.paint.ImageImporter;
import jemu.ui.paint.ImagePreview;
import jemu.ui.paint.ImageProcessor;
import jemu.ui.paint.RGBColor;
import jemu.ui.paint.RasterPaint;
import jemu.ui.paint.importPCX;
import jemu.ui.paint.importTGA;
import jemu.ui.paint.miniFont;
import jemu.ui.paint.overscanPaint;
import org.monte.ilbmdemo.ILBMViewer;

public class OverscanCanvas
extends JLabel
implements MouseListener,
MouseMotionListener {
    public int zoomvalue = 4;
    public boolean zoomit = false;
    protected int xoffset;
    protected int yoffset;
    public boolean setzoom = false;
    public boolean overscan = true;
    Color crossfade1;
    Color crossfade2;
    public boolean stretch = false;
    CPCize lut = new CPCize();
    RGBColor color = new RGBColor();
    public static boolean green = false;
    public int rasterval = 120;
    int[] CPCpalette;
    public static boolean blur = false;
    public static boolean sharp = false;
    float ninth = 0.25f;
    public static final float[] SHARPEN3x3 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static final float[] BLUR3x3 = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
    int[] greenscreen = new int[]{0, 2, 3, 5, 7, 9, 10, 12, 14, 15, 17, 19, 20, 22, 24, 26};
    BufferedImageOp blurOp = new ConvolveOp(new Kernel(3, 3, BLUR3x3));
    BufferedImageOp sharpOp = new ConvolveOp(new Kernel(3, 3, SHARPEN3x3));
    public String importname = null;
    protected int importscr = 0;
    String[] output = new String[]{""};
    String minitext = "";
    int textpen = 1;
    int smoothpen = 16;
    int minisize = 0;
    int transback = 16;
    boolean debug = false;
    public static int filled;
    boolean resPal = false;
    int RedPixel;
    int GreenPixel;
    int BluePixel;
    int startup = 1;
    miniFont minifont = new miniFont();
    JCheckBox restorePal = new JCheckBox("Restore palette");
    public Color random = new Color(20, 60, 90);
    public int[] realInks = new int[27];
    public int checkPal = 0;
    boolean flip;
    public int transpen = 17;
    int shapeX;
    int shapeY;
    int shapeW;
    int shapeH;
    public int bold = 0;
    public int italic = 0;
    byte[] input;
    public boolean gray = false;
    String loadname = "";
    public String showname = "JavaCPC Paint 1.0";
    BufferedImage posterizedImage = null;
    BufferedImage scrollImage = null;
    BufferedImage sourceImage = null;
    BufferedImage loadedImage = null;
    BufferedImage shapeBrush = null;
    BufferedImage CPCImage = null;
    BufferedImage CPCScreen = null;
    boolean doCycle = true;
    static int recalculate;
    int[] counted;
    protected String[] cpccolors = new String[]{"Black", "Blue", "Bright Blue", "Red", "Magenta", "Mauve", "Bright Red", "Purple", "Bright Magenta", "Green", "Cyan", "Sky Blue", "Yellow", "White", "Pastel Blue", "Orange", "Pink", "Pastel Magenta", "Bright Green", "Sea Green", "Bright Cyan", "Lime", "Pastel Green", "Pastel Cyan", "Bright Yellow", "Pastel Yellow", "Bright White"};
    protected static int[] GateArrayINKs;
    protected static int[] GateArrayColors;
    protected static final int[] GateArrayOrg;
    protected static final int[] GateArrayGreens;
    protected Color[] Col = new Color[27];
    private final int CANVAS_WIDTH = 768;
    private final int CANVAS_HEIGHT = 544;
    public int bright = 100;
    public int contrast = 100;
    public boolean keep = false;
    public boolean keepinks = false;
    public static boolean horizontal;
    public int scroll = 0;
    public int scrollb = 0;
    int cycled = 0;
    protected boolean paintscreen = false;
    public int CPCRed;
    public int CPCBlue;
    public int CPCGreen;
    int[] palcount;
    int[] outcount = new int[16];
    public String fontname = "Verdana";
    public int[] undo = new int[65535];
    final URL cursor1 = this.getClass().getResource("icons/cursor2.gif");
    final Image Cursor1 = this.getToolkit().getImage(this.cursor1);
    final URL cursor2 = this.getClass().getResource("icons/cursor1.gif");
    final Image Cursor2 = this.getToolkit().getImage(this.cursor2);
    final Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(this.Cursor1, new Point(15, 15), "Cursor");
    public int MODE_PAINT = 1;
    public int MODE_TEXT = 2;
    public int MODE_LINE = 3;
    public int MODE_RECTANGLE = 4;
    public int MODE_CIRCLE = 5;
    public int MODE_FRECT = 6;
    public int MODE_FCIRCLE = 7;
    public int MODE_IMPORT = 8;
    public int MODE_COPY = 9;
    public int MODE_PASTE = 10;
    public int MODE_MINITEXT = 11;
    public int MODE_FILL = 12;
    public int MODE = this.MODE_PAINT;
    public int textX;
    public int textY;
    public String text = "";
    public int textsize = 30;
    boolean draw = false;
    private int lineX;
    private int lineY;
    private int toX;
    private int toY;
    protected boolean paint;
    private int lastX;
    private int lastY;
    public int pen = 1;
    public int mode = GateArray.getSMode();
    protected boolean painted = true;
    protected int zoomx;
    protected int zoomy;
    int mx;
    int my;
    boolean wasOnTop = false;
    int count = 0;
    JFileChooser chooser = null;
    boolean scr;
    public static boolean plusmode;
    protected byte[] pluspalette = new byte[32];
    float[] gain = new float[]{-1.0f, -0.99f, -0.98f, -0.97f, -0.96f, -0.95f, -0.94f, -0.93f, -0.92f, -0.91f, -0.9f, -0.89f, -0.88f, -0.87f, -0.86f, -0.85f, -0.84f, -0.83f, -0.82f, -0.81f, -0.8f, -0.79f, -0.78f, -0.77f, -0.76f, -0.75f, -0.74f, -0.73f, -0.72f, -0.71f, -0.7f, -0.69f, -0.68f, -0.67f, -0.66f, -0.65f, -0.64f, -0.63f, -0.62f, -0.61f, -0.6f, -0.59f, -0.58f, -0.57f, -0.56f, -0.55f, -0.54f, -0.53f, -0.52f, -0.51f, -0.5f, -0.49f, -0.48f, -0.47f, -0.46f, -0.45f, -0.44f, -0.43f, -0.42f, -0.41f, -0.4f, -0.39f, -0.38f, -0.37f, -0.36f, -0.35f, -0.34f, -0.33f, -0.32f, -0.31f, -0.3f, -0.29f, -0.28f, -0.27f, -0.26f, -0.25f, -0.24f, -0.23f, -0.22f, -0.21f, -0.2f, -0.19f, -0.18f, -0.17f, -0.16f, -0.15f, -0.14f, -0.13f, -0.12f, -0.11f, -0.1f, -0.09f, -0.08f, -0.07f, -0.06f, -0.05f, -0.04f, -0.03f, -0.02f, -0.01f, 0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f};
    ContrastFilter ctr = new ContrastFilter();
    GainFilter gfilt = new GainFilter();
    HSBAdjustFilter hsb = new HSBAdjustFilter();
    public int gainvalue = 150;
    public int sat = 100;
    public int hue = 100;
    public boolean paletteMethod = true;
    boolean DEBUG_RENDER = false;
    public boolean prerender = false;
    int[] steps = new int[]{4, 2, 1};
    int[] squarepixelRow1 = new int[4];
    int[] squarepixelRow2 = new int[4];
    Color[] pixelRow1 = new Color[4];
    Color[] pixelRow2 = new Color[4];
    int[] squareRedR1 = new int[4];
    int[] squareGreenR1 = new int[4];
    int[] squareBlueR1 = new int[4];
    int[] squareRedR2 = new int[4];
    int[] squareGreenR2 = new int[4];
    int[] squareBlueR2 = new int[4];
    int conv;
    importTGA tga;
    importPCX pcx;
    ILBMViewer ilbm;
    protected String PBM_HEADER = "PBM BMHD";
    protected String ILBM_HEADER = "ILBM";
    ImageImporter imageImporter = new ImageImporter();
    int[] palette = new int[16];
    int[] greypal = new int[]{3, 25, 16, 7, 6, 5, 10, 11, 13, 15, 0, 18, 20, 22, 23, 1};
    public double zoomfactor = 1.0;
    int oldscroll = 0;
    int oldscroll2 = 0;
    protected BufferedImage buffershow;
    public boolean dlevel;
    BumpFilter bump = new BumpFilter();
    int EDGE_1 = 32;
    int EDGE_2 = 96;
    int EDGE_3 = 160;
    int EDGE_4 = 222;
    protected static final int[] ditherBayer4x4Matrix;
    protected static final int[] ditherBayer8x8Matrix;
    protected static final int[] ditherMagic4x4Matrix;
    public static final int[] ditherOrdered4x4Matrix;
    public static final int[] ditherLines4x4Matrix;
    public static final int[] dither90Halftone6x6Matrix;
    public static final int[] ditherOrdered6x6Matrix;
    public static final int[] ditherOrdered8x8Matrix;
    public static final int[] ditherCluster3Matrix;
    public static final int[] ditherCluster4Matrix;
    public static final int[] ditherCluster8Matrix;
    public final int MATRIX_4x4_BAYER = 1;
    public final int MATRIX_8x8_BAYER = 2;
    public final int MATRIX_4x4_SQUARE = 3;
    public final int MATRIX_4x4_ORDERED = 4;
    public final int MATRIX_4x4_LINES = 5;
    public final int MATRIX_6x6_HALFTONE = 6;
    public final int MATRIX_6x6_ORDERED = 7;
    public final int MATRIX_8x8_ORDERED = 8;
    public final int MATRIX_CLUSTER3 = 9;
    public final int MATRIX_CLUSTER4 = 10;
    public final int MATRIX_CLUSTER8 = 11;
    int[] matrix;
    DitherFilter dither = new DitherFilter();
    public boolean dobump;
    public boolean[] lockPEN = new boolean[16];
    int[] colours = new int[4096];
    int[] used = new int[4096];
    BufferedImage pseudo = new BufferedImage(768, 544, 1);
    BufferedImage pali;
    int[] pals = new int[]{0, 15, 8, 4, 1, 2, 3, 5, 6, 7, 9, 10, 11, 12, 13, 14};
    protected int autoIndex = 0;
    public boolean detected;
    int counter = 1;
    int addr;
    int addg;
    int addb;
    int dark = 85;
    int medium = 170;
    final int swidth = 768;
    final int sheight = 544;
    BufferedImage outimage;
    int mousebutton = 0;
    int cols = 0;
    int reset = 0;
    int cycles;
    public static boolean autostore;
    int recalc = 0;
    BufferedImage showImage = new BufferedImage(384, 272, 4);
    BufferedImage bzm = new BufferedImage(384, 272, 1);
    ItemListener restoreListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int state = itemEvent.getStateChange();
            if (state == 1) {
                OverscanCanvas.this.resPal = true;
            }
            if (state == 2) {
                OverscanCanvas.this.resPal = false;
            }
        }
    };
    int mask = 0xFFFFFF;
    protected int[] xx = new int[800];
    protected int[] yy = new int[800];
    protected int z;
    protected int xStep;
    protected int yStep;
    protected Color hf;
    protected Color vfl;
    protected Color vfr;
    protected Color fr;
    protected Color fl;
    protected int fillX;
    protected int fillY;
    protected boolean showFill = true;
    protected boolean filling = false;
    boolean iszoom;
    public int commandInt;
    int dither1;
    int dither2;
    int[] ditherMatrix = new int[2000000];
    int ditherpos = 0;
    public int ditherlevel = 20;
    public int oldditherlevel = -2;
    public int dithermethod = 3;
    public byte[][] buffer = new byte[20][31953];
    public int choosenImage = 0;
    boolean screenChanged = true;

    @Override
    public void mousePressed(MouseEvent event) {
        this.mousebutton = event.getButton();
        if (this.zoomit && this.mousebutton != 1) {
            return;
        }
        if (this.setzoom) {
            int i = event.getX();
            int j = event.getY();
            int xs = 1;
            int ys = 2;
            if (this.mode == 0) {
                xs = 4;
            }
            if (this.mode == 1) {
                xs = 2;
            }
            i = i / xs * this.zoomvalue * xs * this.zoomvalue;
            j = j / ys * this.zoomvalue * ys * this.zoomvalue;
            this.putScreen();
            Graphics page = this.getGraphics();
            page.setColor(new Color(Util.random(0xFFFFFF)));
            int px = i - 768 / this.zoomvalue / 2;
            int py = j - 544 / this.zoomvalue / 2;
            px = px / xs * this.zoomvalue * xs * this.zoomvalue;
            py = py / ys * this.zoomvalue * ys * this.zoomvalue;
            page.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        this.makeUndo();
        int gotX = event.getX();
        int gotY = event.getY();
        this.lastX = gotX;
        this.lastY = gotY;
        int x = this.lastX;
        int y = this.lastY / 2;
        if (this.mode == 0) {
            x /= 4;
        }
        if (this.mode == 1) {
            x /= 2;
        }
        switch (this.MODE) {
            case 1: {
                if (this.paint) {
                    this.plot(x, y, this.pen);
                }
                this.painted = true;
                this.putScreen();
                break;
            }
            case 3: {
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 4: {
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 5: {
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 6: {
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 7: {
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 9: {
                this.lineX = gotX;
                this.lineY = gotY;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int yc;
        int xc;
        if (this.zoomit && this.mousebutton != 1) {
            if (this.mx > event.getX()) {
                this.subX();
            }
            if (this.mx < event.getX()) {
                this.addX();
            }
            if (this.my > event.getY()) {
                this.subY();
            }
            if (this.my < event.getY()) {
                this.addY();
            }
            this.my = event.getY();
            this.mx = event.getX();
            return;
        }
        if (this.MODE == this.MODE_FILL && this.filling) {
            return;
        }
        if (this.setzoom) {
            int x = event.getX();
            int y = event.getY();
            int i = 1;
            int j = 2;
            if (this.mode == 0) {
                i = 4;
            }
            if (this.mode == 1) {
                i = 2;
            }
            x = x / i * this.zoomvalue * i * this.zoomvalue;
            y = y / j * this.zoomvalue * j * this.zoomvalue;
            this.putScreen();
            Graphics graphics = this.getGraphics();
            graphics.setColor(new Color(Util.random(0xFFFFFF)));
            int px = x - 768 / this.zoomvalue / 2;
            int py = y - 544 / this.zoomvalue / 2;
            px = px / i * this.zoomvalue * i * this.zoomvalue;
            py = py / j * this.zoomvalue * j * this.zoomvalue;
            graphics.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        Graphics page = this.getGraphics();
        int gotX = event.getX();
        int gotY = event.getY();
        this.zoomx = gotX;
        this.zoomy = gotY;
        filled = 0;
        int xn = gotX;
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        if (this.zoomit) {
            xc = gotX / xs * this.zoomvalue * xs * this.zoomvalue;
            yc = gotY / ys * this.zoomvalue * ys * this.zoomvalue;
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        this.lineX = this.lineX / xs * xs;
        this.lineY = this.lineY / ys * ys;
        int yn = gotY / 2;
        if (this.mode == 0) {
            xn /= 4;
        }
        if (this.mode == 1) {
            xn /= 2;
        }
        int fromx = this.lineX;
        int fromy = this.lineY;
        int tox = this.toX - this.lineX;
        int toy = this.toY - this.lineY;
        if (this.toX < this.lineX) {
            fromx = this.toX;
            tox = this.lineX - this.toX;
        } else {
            fromx = this.lineX;
            tox = this.toX - this.lineX;
        }
        if (this.toY < this.lineY) {
            fromy = this.toY;
            toy = this.lineY - this.toY;
        } else {
            fromy = this.lineY;
            toy = this.toY - this.lineY;
        }
        tox = tox / xs * xs;
        toy = toy / ys * ys;
        switch (this.MODE) {
            case 1: {
                if (this.paint) {
                    this.plot(xn, yn, this.pen);
                    page.setColor(CPC.getCol(this.pen));
                }
                this.lastX = gotX;
                this.lastY = gotY;
                this.putScreen();
                this.painted = true;
                break;
            }
            case 3: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawLine(this.lineX, this.lineY, this.toX, this.toY);
                page.drawLine(this.lineX, this.lineY + 1, this.toX, this.toY + 1);
                if (this.mode == 1 || this.mode == 0) {
                    page.drawLine(this.lineX + 1, this.lineY, this.toX + 1, this.toY);
                    page.drawLine(this.lineX + 1, this.lineY + 1, this.toX + 1, this.toY + 1);
                }
                if (this.mode != 0) break;
                page.drawLine(this.lineX + 2, this.lineY, this.toX + 2, this.toY);
                page.drawLine(this.lineX + 2, this.lineY + 1, this.toX + 2, this.toY + 1);
                page.drawLine(this.lineX + 3, this.lineY, this.toX + 3, this.toY);
                page.drawLine(this.lineX + 3, this.lineY + 1, this.toX + 3, this.toY + 1);
                break;
            }
            case 4: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawRect(fromx, fromy, tox, toy);
                page.drawRect(fromx, fromy + 1, tox, toy);
                if (this.mode == 1 || this.mode == 0) {
                    page.drawRect(fromx + 1, fromy, tox, toy);
                    page.drawRect(fromx + 1, fromy + 1, tox, toy);
                }
                if (this.mode != 0) break;
                page.drawRect(fromx + 2, fromy, tox, toy);
                page.drawRect(fromx + 2, fromy + 1, tox, toy);
                page.drawRect(fromx + 3, fromy, tox, toy);
                page.drawRect(fromx + 3, fromy + 1, tox, toy);
                break;
            }
            case 5: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                this.cross(xc, yc);
                page.drawOval(fromx, fromy, tox, toy);
                break;
            }
            case 6: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.fillRect(fromx, fromy, tox + xs, toy + ys);
                break;
            }
            case 7: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                this.cross(xc, yc);
                page.fillOval(fromx, fromy, tox + xs, toy + ys);
                break;
            }
            case 9: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawRect(fromx, fromy, tox, toy);
                page.drawRect(fromx, fromy + 1, tox, toy);
                this.shapeX = fromx;
                this.shapeY = fromy;
                this.shapeW = tox;
                this.shapeH = toy;
                if (this.mode == 1 || this.mode == 0) {
                    page.drawRect(fromx + 1, fromy, tox, toy);
                    page.drawRect(fromx + 1, fromy + 1, tox + 1, toy);
                }
                if (this.mode != 0) break;
                page.drawRect(fromx + 2, fromy, tox, toy);
                page.drawRect(fromx + 2, fromy + 1, tox, toy);
                page.drawRect(fromx + 3, fromy, tox, toy);
                page.drawRect(fromx + 3, fromy + 1, tox, toy);
            }
        }
        this.drawCross(xc, yc, xs, ys);
    }

    public void plot(int x, int y, int p) {
        if (this.zoomit) {
            int xd = 1;
            if (this.mode == 0) {
                xd = 4;
            }
            if (this.mode == 1) {
                xd = 2;
            }
            x = x / this.zoomvalue + this.xoffset / xd;
            y = y / this.zoomvalue + this.yoffset / 2;
        }
        int w = 768;
        if (this.mode == 1) {
            w /= 2;
        }
        if (this.mode == 0) {
            w /= 4;
        }
        if (x >= 0 && y >= 0 && x <= w && y <= 272) {
            CPC.PLOT(x, y, p, this.mode, this.overscan);
        }
    }

    public OverscanCanvas() {
        int offset = 0;
        for (int r = 0; r < 16; ++r) {
            for (int g = 0; g < 16; ++g) {
                for (int b = 0; b < 16; ++b) {
                    this.colours[offset++] = GateArray.putRGB(GateArray.LUM(r), GateArray.LUM(g), GateArray.LUM(b));
                }
            }
        }
        for (int pf = 0; pf < 27; ++pf) {
            this.Col[pf] = green ? new Color(GateArrayGreens[pf]) : new Color(GateArrayColors[pf]);
        }
        this.crossfade1 = new Color(255, 80, 128);
        this.crossfade2 = new Color(128, 80, 255);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(this.cursor);
        this.setBackground(Color.white);
        this.setSize(768, 544);
        this.setPreferredSize(new Dimension(768, 544));
        this.restorePal.addItemListener(this.restoreListener);
        this.loadScreens();
    }

    public void writeOverscan() {
        this.wasOnTop = CPC.PaintOnTop;
        CPC.PaintOnTop = false;
        CPC.setPaintOnTop = true;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Save overscan SCR", 1);
            filedia.setFile("*.SCR");
            filedia.setVisible(true);
            String filename = null;
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                if (!filename.toLowerCase().endsWith(".scr")) {
                    filename = filename + ".SCR";
                }
                if (plusmode) {
                    CPC.BIN_Export(filename, 512, 31936, 2081, true);
                } else {
                    CPC.BIN_Export(filename, 512, 31936, 2065, true);
                }
            }
            CPC.PaintOnTop = this.wasOnTop;
            CPC.setPaintOnTop = true;
        }
        catch (Exception e) {
            System.err.println("Save Overscan image failed...");
            CPC.PaintOnTop = this.wasOnTop;
            CPC.setPaintOnTop = true;
        }
    }

    public void convertScreen() {
        filled = 0;
        recalculate = 0;
        this.MODE = this.MODE_IMPORT;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.addChoosableFileFilter(new ImageFilter());
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setFileView(new ImageFileView());
            this.chooser.setAccessory(new ImagePreview(this.chooser));
            this.chooser.setPreferredSize(new Dimension(800, 600));
            this.chooser.setMultiSelectionEnabled(false);
        }
        this.chooser.setCurrentDirectory(new File(DSettings.get("paint_path", "")));
        if (this.chooser.showOpenDialog(this) == 0) {
            String filename;
            DSettings.set("paint_path", this.chooser.getSelectedFile().getPath());
            this.doCycle = false;
            this.loadname = filename = this.chooser.getSelectedFile().getAbsolutePath();
            this.showname = this.chooser.getSelectedFile().getName();
            overscanPaint.output.append("Reading " + this.loadname + " in progress...\n");
            if (this.loadname.length() > 2) {
                this.convertScreen(this.loadname);
            }
        }
    }

    public void SCRimport(String loadname) {
        filled = 0;
        this.scr = true;
        OverscanCanvas.resetCPCColours();
        System.arraycopy(CPC.pale, 0, CPC.Palcols, 0, 16);
        plusmode = false;
        try {
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(loadname));
            this.input = new byte[bos.available()];
            this.count = 0;
            while (bos.available() > 0) {
                this.input[this.count] = (byte)bos.read();
                ++this.count;
            }
            bos.close();
            boolean plus = false;
            int start = 0;
            if (this.input.length > 31936) {
                start = 128;
            }
            plus = this.input[1569 + start] == -13;
            int address = 512;
            byte mod = this.input[1536 + start];
            System.out.println("Found: " + Util.hex(mod));
            int smode = 0;
            if (mod == -116 || mod == 0) {
                smode = 0;
            }
            if (mod == -115 || mod == 1) {
                smode = 1;
            }
            if (mod == -114 || mod == 2) {
                smode = 2;
            }
            if (!plus && smode != GateArray.getSMode()) {
                if (smode == 0) {
                    CPC.POKE(36863, 3);
                } else {
                    CPC.POKE(36863, smode);
                }
            }
            int palette = 1537 + start;
            if (!plus) {
                for (int j = 0; j < 16; ++j) {
                    OverscanCanvas.INK(j, this.input[palette + j]);
                }
            }
            for (int i = start; i < this.input.length; ++i) {
                GateArray.screenmemory[address++] = this.input[i];
            }
            if (plus) {
                plusmode = true;
                ImageProcessor.plus.setSelected(true);
                ImageProcessor.divider.setEnabled(true);
                ImageProcessor.dlabel.setEnabled(true);
                this.makePlus(this.input, start);
            } else {
                ImageProcessor.plus.setSelected(false);
                ImageProcessor.divider.setEnabled(false);
                ImageProcessor.dlabel.setEnabled(false);
            }
            boolean bl = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetCPCColours() {
        System.arraycopy(GateArrayOrg, 0, GateArrayColors, 0, GateArrayColors.length);
        GateArray.resetCPCColours();
        for (int i = 0; i < 27; ++i) {
            CPC.Palcols[i] = new Color(GateArrayColors[i]);
        }
    }

    public void makePlus(byte[] in, int start) {
        int ad = 1537 + start;
        byte mod = in[1536 + start];
        int smode = 0;
        if (mod == -116) {
            smode = 0;
        }
        if (mod == -115) {
            smode = 1;
        }
        if (mod == -114) {
            smode = 2;
        }
        if (smode != GateArray.getSMode()) {
            if (smode == 0) {
                CPC.POKE(36863, 3);
            } else {
                CPC.POKE(36863, smode);
            }
        }
        try {
            int pos = 0;
            this.pluspalette = new byte[32];
            for (int i = 0; i < 16; ++i) {
                byte p;
                this.pluspalette[pos] = p = in[ad];
                String b1 = Util.hex(p);
                this.pluspalette[pos + 1] = p = in[ad + 1];
                ad += 2;
                pos += 2;
                String b2 = Util.hex(p);
                b2 = b2.substring(1);
                String result = b1 + b2;
                String r = "" + result.charAt(0);
                String b = "" + result.charAt(1);
                String g = "" + result.charAt(2);
                result = r + r + g + g + b + b;
                CPC.Palcols[i] = new Color(Util.hexValue(result));
                OverscanCanvas.GateArrayColors[i] = Util.hexValue(result);
                GateArray.setPalette(i, Util.hexValue(result));
                CPC.inksEdited = false;
                OverscanCanvas.INK(i, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getPlusPalette() {
        if (!plusmode) {
            return new byte[this.pluspalette.length];
        }
        this.makePlusPalette();
        return this.pluspalette;
    }

    public void makePlusPalette() {
        try {
            for (int pen = 0; pen < 16; ++pen) {
                int pos = pen * 2;
                int f = GateArrayColors[pen];
                int[] rgb = this.getRGB(f);
                int r = rgb[0] >> 4;
                int g = rgb[1] >> 4;
                int b = rgb[2] >> 4;
                String R = Integer.toHexString(r);
                String G = Integer.toHexString(g);
                String B = Integer.toHexString(b);
                String result = R + B;
                int bg = Util.hexValue(result);
                this.pluspalette[pos] = (byte)bg;
                result = G;
                bg = Util.hexValue(result);
                this.pluspalette[pos + 1] = (byte)bg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPENs() {
        int coloursToSet = 0;
        this.CPCImage = null;
        if (this.mode == 0) {
            coloursToSet = 16;
        }
        if (this.mode == 1) {
            coloursToSet = 4;
        }
        if (this.mode == 2) {
            coloursToSet = 2;
        }
        this.CPCpalette = new int[coloursToSet];
        for (int i = 0; i < coloursToSet; ++i) {
            this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
        }
    }

    public void refactorImage(boolean build) {
        Graphics2D g2;
        filled = 0;
        int colours = 0;
        this.CPCImage = null;
        if (this.mode == 0) {
            this.CPCImage = new BufferedImage(192, 272, 1);
            colours = 16;
        }
        if (this.mode == 1) {
            this.CPCImage = new BufferedImage(384, 272, 1);
            colours = 4;
        }
        if (this.mode == 2) {
            this.CPCImage = new BufferedImage(768, 272, 1);
            colours = 2;
        }
        if (blur) {
            g2 = (Graphics2D)this.loadedImage.getGraphics();
            g2.drawImage(this.loadedImage, this.blurOp, 0, 0);
            this.loadedImage.getGraphics().drawImage(this.loadedImage, 0, 0, this);
        }
        if (sharp) {
            g2 = (Graphics2D)this.loadedImage.getGraphics();
            g2.drawImage(this.loadedImage, this.sharpOp, 0, 0);
            this.loadedImage.getGraphics().drawImage(this.loadedImage, 0, 0, this);
        }
        this.CPCpalette = new int[colours];
        for (int i = 0; i < colours; ++i) {
            this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
        }
        if (build) {
            this.buildCPCPalette(this.paletteMethod ? this.loadedImage : this.CPCImage);
        }
        int lw = this.loadedImage.getWidth();
        int lh = this.loadedImage.getHeight();
        if (lw != 768 || lh != 544) {
            return;
        }
        this.CPCImage.getGraphics().drawImage(this.loadedImage, 0, 0, this.CPCImage.getWidth(), 272, this);
        this.buildCPCScreen(this.CPCImage, this.CPCpalette);
    }

    public void preRender(BufferedImage CPCImage) {
        try {
            this.prerender = ImageProcessor.precalculate != null && this.isVisible() ? ImageProcessor.precalculate.isSelected() && !plusmode : RasterPaint.prerender.isSelected();
            if (RasterPaint.control != null && RasterPaint.control.isVisible() && !this.isVisible()) {
                this.prerender = RasterPaint.prerender.isSelected();
            }
            if (!this.prerender) {
                return;
            }
            boolean reverseOrder = false;
            if (ImageProcessor.precalculate != null && ImageProcessor.preorder.isSelected()) {
                reverseOrder = true;
            }
            if (RasterPaint.control != null && RasterPaint.control.isVisible()) {
                reverseOrder = RasterPaint.reverse.isSelected();
            }
            System.out.println(reverseOrder);
            int width = CPCImage.getWidth();
            int height = CPCImage.getHeight();
            for (int y = 0; y < height; ++y) {
                boolean isEven;
                boolean bl = isEven = y % 2 == 0;
                if (reverseOrder) {
                    isEven = !isEven;
                }
                for (int x = 0; x < width; ++x) {
                    int pixel = CPCImage.getRGB(x, y);
                    isEven = !isEven;
                    Color pixelColor = new Color(pixel);
                    int red = pixelColor.getRed();
                    int green = pixelColor.getGreen();
                    int blue = pixelColor.getBlue();
                    red = red > this.EDGE_1 && red < this.EDGE_2 ? (isEven ? 128 : 0) : (red >= this.EDGE_2 && red < this.EDGE_3 ? 128 : (red >= this.EDGE_3 && red < this.EDGE_4 ? (isEven ? 255 : 128) : (red >= this.EDGE_4 ? 255 : 0)));
                    green = green > this.EDGE_1 && green < this.EDGE_2 ? (isEven ? 128 : 0) : (green >= this.EDGE_2 && green < this.EDGE_3 ? 128 : (green >= this.EDGE_3 && green < this.EDGE_4 ? (isEven ? 255 : 128) : (green >= this.EDGE_4 ? 255 : 0)));
                    blue = blue > this.EDGE_1 && blue < this.EDGE_2 ? (isEven ? 128 : 0) : (blue >= this.EDGE_2 && blue < this.EDGE_3 ? 128 : (blue >= this.EDGE_3 && blue < this.EDGE_4 ? (isEven ? 255 : 128) : (blue >= this.EDGE_4 ? 255 : 0)));
                    pixelColor = new Color(red, green, blue);
                    CPCImage.setRGB(x, y, pixelColor.getRGB());
                }
            }
            if (this.DEBUG_RENDER) {
                try {
                    BufferedImage testImage = new BufferedImage(640, 400, 1);
                    testImage.createGraphics().drawImage(CPCImage, 0, 0, 640, 400, this);
                    File a = new File("./Rendertest/");
                    if (!a.exists()) {
                        a.mkdir();
                    }
                    ImageIO.write((RenderedImage)testImage, "PNG", new File("./Rendertest/TestOverscan.png"));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void preCalculate(BufferedImage CPCImage, int snap) {
        try {
            int width = CPCImage.getWidth();
            int height = CPCImage.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = CPCImage.getRGB(x, y);
                    Color pixelColor = new Color(pixel);
                    int red = pixelColor.getRed();
                    int green = pixelColor.getGreen();
                    int blue = pixelColor.getBlue();
                    red = red / snap * snap;
                    green = green / snap * snap;
                    blue = blue / snap * snap;
                    pixelColor = new Color(red, green, blue);
                    CPCImage.setRGB(x, y, pixelColor.getRGB());
                }
            }
            if (this.DEBUG_RENDER) {
                try {
                    ImageIO.write((RenderedImage)CPCImage, "PNG", new File("C:/JavaCPC/Rendertest/TestPrecalculate.png"));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BufferedImage convert4(BufferedImage src) {
        int[] cmap = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
        return OverscanCanvas.convert4(src, cmap);
    }

    public static BufferedImage convert4(BufferedImage src, int[] cmap) {
        IndexColorModel icm = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public BufferedImage convert8(BufferedImage src) {
        BufferedImage convertedImage = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        for (int x = 0; x < src.getWidth(); ++x) {
            for (int y = 0; y < src.getHeight(); ++y) {
                convertedImage.setRGB(x, y, src.getRGB(x, y));
            }
        }
        return convertedImage;
    }

    public static BufferedImage convert8D(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        Graphics2D g2 = dest.createGraphics();
        cco.filter(src, dest);
        return dest;
    }

    public void posterize() {
        filled = 0;
        String filename = this.loadname;
        if (filename != null) {
            try {
                int n = JOptionPane.showConfirmDialog(this, "Store double sized?", "Please choose outputformat", 0);
                if (n == 0) {
                    n = 2;
                }
                BufferedImage pimage = this.imageImporter.readImage(filename);
                BufferedImage gimage = new BufferedImage(pimage.getWidth() * n, pimage.getHeight() * n, 4);
                gimage.getGraphics().drawImage(pimage, 0, 0, gimage.getWidth(), gimage.getHeight(), this);
                BufferedImage out = null;
                out = this.mode == 0 ? new BufferedImage(gimage.getWidth() / 4, gimage.getHeight() / 2, 4) : (this.mode == 1 ? new BufferedImage(gimage.getWidth() / 2, gimage.getHeight() / 2, 4) : new BufferedImage(gimage.getWidth(), gimage.getHeight() / 2, 4));
                out.getGraphics().drawImage(gimage, 0, 0, out.getWidth(), out.getHeight(), this);
                out = this.FilterImage2(out, true);
                int colours = 0;
                if (this.mode == 0) {
                    colours = 16;
                }
                if (this.mode == 1) {
                    colours = 4;
                }
                if (this.mode == 2) {
                    colours = 2;
                }
                for (int i = 0; i < colours; ++i) {
                    this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
                }
                this.buildCPCScreen(out, this.CPCpalette);
                gimage.getGraphics().drawImage(out, 0, 0, gimage.getWidth(), gimage.getHeight(), this);
                FileDialog filedia = new FileDialog(new Frame(), "Save posterized screen", 1);
                filedia.setFile("*.png");
                filedia.setVisible(true);
                filename = null;
                filename = filedia.getFile();
                if (filename != null) {
                    filename = filedia.getDirectory() + filedia.getFile();
                    if (!filename.toLowerCase().endsWith(".png")) {
                        filename = filename + ".png";
                    }
                    this.savescreen(gimage, filename, "png");
                }
            }
            catch (Exception e) {
                System.out.println("Load failed...");
                overscanPaint.output.append("*** Error *** Import failed.\n");
                return;
            }
        }
    }

    public void buildGreenPalette() {
        if (!green) {
            for (int i = 0; i < 16; ++i) {
                try {
                    this.palette[i] = GateArray.getInk(i);
                    OverscanCanvas.INK(i, this.greypal[i]);
                    continue;
                }
                catch (Exception e) {
                    overscanPaint.output.append("Something went wrong...\nHave you been too fast?\n");
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                try {
                    OverscanCanvas.INK(i, this.palette[i]);
                    continue;
                }
                catch (Exception e) {
                    overscanPaint.output.append("Something went wrong...\nHave you been too fast?\n");
                }
            }
        }
        green = !green;
    }

    public String showname() {
        return this.showname;
    }

    public void convertScreen(String loadname) {
        int value;
        filled = 0;
        this.mode = GateArray.getSMode();
        recalculate = 0;
        this.MODE = this.MODE_IMPORT;
        this.scr = false;
        if (loadname.toLowerCase().endsWith(".scr") || loadname.toLowerCase().endsWith(".bin")) {
            this.SCRimport(loadname);
            return;
        }
        this.cycled = 0;
        this.scrollImage = null;
        this.posterizedImage = null;
        this.sourceImage = null;
        try {
            this.loadedImage = this.imageImporter.readImage(loadname);
        }
        catch (Exception e) {
            System.out.println("**** Error: Load failed...");
            return;
        }
        this.detected = false;
        int orig_width = this.loadedImage.getWidth();
        int orig_height = this.loadedImage.getHeight();
        int newwidth = 768;
        int newheight = 544;
        float ratio = orig_width / orig_height;
        double scale = (double)orig_width / 768.0;
        if ((double)ratio > 1.4117647) {
            scale = (double)orig_height / 544.0;
        }
        double width = (double)orig_width / scale;
        double height = (double)orig_height / scale;
        overscanPaint.ScrollUpDown.setValue(0);
        overscanPaint.ScrollLeftRight.setValue(0);
        newwidth = (int)width;
        newheight = (int)height;
        if (this.keep) {
            newwidth = (int)((double)orig_width * this.zoomfactor);
            newheight = (int)((double)orig_height * this.zoomfactor);
        }
        if (this.stretch) {
            newwidth = 768;
            newheight = 544;
        }
        overscanPaint.output.append("Image size: " + orig_width + "x" + orig_height + ", ratio = " + ratio + "\n");
        overscanPaint.output.append("Size viewed: 768x544, ratio = 1.4117647 Origin : (" + this.scroll + "," + this.scrollb + "\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.sourceImage = this.gray ? new BufferedImage(newwidth, newheight, 10) : new BufferedImage(newwidth, newheight, 1);
        this.sourceImage.getGraphics().drawImage(this.loadedImage, 0, 0, newwidth, newheight, this);
        this.loadedImage = new BufferedImage(this.sourceImage.getWidth(), this.sourceImage.getHeight(), 1);
        this.loadedImage.getGraphics().drawImage(this.sourceImage, 0, 0, newwidth, newheight, this);
        this.scrollImage = new BufferedImage(this.loadedImage.getWidth(), this.loadedImage.getHeight(), 1);
        this.scrollImage.getGraphics().drawImage(this.loadedImage, 0, 0, this.loadedImage.getWidth(), this.loadedImage.getHeight(), this);
        recalculate = 1;
        if (this.scrollImage.getHeight() - 544 > 0) {
            value = this.scrollImage.getHeight() - 544;
            overscanPaint.ScrollUpDown.setMaximum(value);
            overscanPaint.ScrollUpDown.setEnabled(true);
        } else {
            overscanPaint.ScrollUpDown.setMaximum(0);
            overscanPaint.ScrollUpDown.setEnabled(false);
        }
        if (this.scrollImage.getWidth() - 768 > 0) {
            value = this.scrollImage.getWidth() - 768;
            overscanPaint.ScrollLeftRight.setMaximum(value);
            overscanPaint.ScrollLeftRight.setEnabled(true);
        } else {
            overscanPaint.ScrollLeftRight.setMaximum(0);
            overscanPaint.ScrollLeftRight.setEnabled(false);
        }
        overscanPaint.ScrollUpDown.setEnabled(true);
        overscanPaint.ScrollLeftRight.setEnabled(true);
        this.posterizedImage = null;
        this.paintscreen = true;
        this.cycled = 1;
        this.clear();
        overscanPaint.output.append("Reading Ok.\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.doCycle = true;
    }

    public void scrollImage() {
        filled = 0;
        if (this.buffershow == null) {
            this.buffershow = new BufferedImage(768, 544, 1);
        }
        if (this.oldscroll != this.scrollb || this.oldscroll2 != this.scroll) {
            recalculate = 1;
            this.detected = false;
            Graphics page = this.getGraphics();
            page.drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, 768, 544, 0, 0, 768 + this.scrollb, 544 + this.scroll, this);
            page = this.buffershow.getGraphics();
            page.drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, 768, 544, 0, 0, 768 + this.scrollb, 544 + this.scroll, this);
            page = this.showImage.getGraphics();
            page.drawImage(this.buffershow, 0, 0, 384, 272, null);
        }
        this.oldscroll = this.scrollb;
        this.oldscroll2 = this.scroll;
    }

    public void recalculate() {
        filled = 0;
        this.loadedImage = new BufferedImage(768, 544, 1);
        this.loadedImage.getGraphics().drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, 768, 544, 0, 0, 768 + this.scrollb, 544 + this.scroll, this);
        this.loadedImage = this.FilterImage(this.loadedImage, false);
    }

    protected BufferedImage preConvert(BufferedImage in, int type) {
        BufferedImage b = new BufferedImage(in.getWidth(), in.getHeight(), type);
        b.createGraphics().drawImage((Image)in, 0, 0, this);
        in.createGraphics().drawImage((Image)b, 0, 0, this);
        return in;
    }

    public void setMatrixMethod(int method) {
        this.matrix = null;
        switch (method) {
            case 1: {
                this.matrix = new int[ditherBayer4x4Matrix.length];
                System.arraycopy(ditherBayer4x4Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 2: {
                this.matrix = new int[ditherBayer8x8Matrix.length];
                System.arraycopy(ditherBayer8x8Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 3: {
                this.matrix = new int[ditherMagic4x4Matrix.length];
                System.arraycopy(ditherMagic4x4Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 4: {
                this.matrix = new int[ditherOrdered4x4Matrix.length];
                System.arraycopy(ditherOrdered4x4Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 5: {
                this.matrix = new int[ditherLines4x4Matrix.length];
                System.arraycopy(ditherLines4x4Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 6: {
                this.matrix = new int[dither90Halftone6x6Matrix.length];
                System.arraycopy(dither90Halftone6x6Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 7: {
                this.matrix = new int[ditherOrdered6x6Matrix.length];
                System.arraycopy(ditherOrdered6x6Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 8: {
                this.matrix = new int[ditherOrdered8x8Matrix.length];
                System.arraycopy(ditherOrdered8x8Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 9: {
                this.matrix = new int[ditherCluster3Matrix.length];
                System.arraycopy(ditherCluster3Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 10: {
                this.matrix = new int[ditherCluster4Matrix.length];
                System.arraycopy(ditherCluster4Matrix, 0, this.matrix, 0, this.matrix.length);
                break;
            }
            case 11: {
                this.matrix = new int[ditherCluster8Matrix.length];
                System.arraycopy(ditherCluster8Matrix, 0, this.matrix, 0, this.matrix.length);
            }
        }
    }

    protected BufferedImage FilterImage(BufferedImage in, boolean poster) {
        Graphics2D g2;
        if (blur) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.blurOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (sharp) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.sharpOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (!(plusmode || this.addr == 0 && this.addg == 0 && this.addb == 0)) {
            this.ManipulateRGB(in);
        }
        int w = this.mode == 0 ? 192 : (this.mode == 1 ? 384 : 768);
        int h = 272;
        if (poster) {
            w = in.getWidth();
            h = in.getHeight();
        }
        BufferedImage out = new BufferedImage(w, h, 1);
        Graphics2D g = out.createGraphics();
        g.drawImage(in, 0, 0, w, h, this);
        BufferedImage bum = new BufferedImage(384, 272, 1);
        if (this.mode == 0) {
            bum = new BufferedImage(192, 272, 1);
        }
        if (this.mode == 2) {
            bum = new BufferedImage(768, 272, 1);
        }
        bum.createGraphics().drawImage(out, 0, 0, bum.getWidth(), 272, this);
        if (poster) {
            bum = new BufferedImage(w, h, 1);
            bum.createGraphics().drawImage(out, 0, 0, w, h, this);
        }
        this.ctr.setContrast(this.gain[this.contrast] + 1.0f);
        this.ctr.setBrightness(this.gain[this.bright] + 1.0f);
        this.ctr.filter(bum, bum);
        this.gfilt.setGain(this.gain[this.gainvalue]);
        this.gfilt.filter(bum, bum);
        this.hsb.setSFactor(this.gain[this.sat]);
        this.hsb.setHFactor(this.gain[this.hue]);
        this.hsb.filter(bum, bum);
        out.createGraphics().drawImage(bum, 0, 0, out.getWidth(), 272, this);
        if (poster) {
            out.createGraphics().drawImage(bum, 0, 0, w, h, this);
        }
        g = in.createGraphics();
        g.drawImage(out, 0, 0, 768, 544, this);
        return in;
    }

    protected BufferedImage FilterImage2(BufferedImage in, boolean poster) {
        Graphics2D g2;
        if (blur) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.blurOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (sharp) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.sharpOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (!(plusmode || this.addr == 0 && this.addg == 0 && this.addb == 0)) {
            this.ManipulateRGB(in);
        }
        this.ctr.setContrast(this.gain[this.contrast] + 1.0f);
        this.ctr.setBrightness(this.gain[this.bright] + 1.0f);
        this.ctr.filter(in, in);
        this.gfilt.setGain(this.gain[this.gainvalue]);
        this.gfilt.filter(in, in);
        this.hsb.setSFactor(this.gain[this.sat]);
        this.hsb.setHFactor(this.gain[this.hue]);
        this.hsb.filter(in, in);
        if (this.dlevel) {
            // empty if block
        }
        return in;
    }

    public static void setPlusInk(int i, int value) {
        CPC.Palcols[i & 0xF] = new Color(value);
        OverscanCanvas.GateArrayColors[i & 0xF] = value;
        GateArray.setPalette(i & 0xF, value);
        CPC.inksEdited = false;
        OverscanCanvas.INK(i & 0xF, i & 0xF);
    }

    protected int[] getRGB(int value) {
        int[] rgb = new int[]{value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF};
        return rgb;
    }

    public void ManipulateRGB(BufferedImage in) {
        for (int x = 0; x < in.getWidth(); ++x) {
            for (int y = 0; y < in.getHeight(); ++y) {
                Graphics g = in.getGraphics();
                g.setColor(this.ManipulateRGB(new Color(in.getRGB(x, y)), this.addr, this.addg, this.addb));
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    public Color ManipulateRGB(Color SourceColor, int addR, int addG, int addB) {
        int r = SourceColor.getRed() + addR;
        int g = SourceColor.getGreen() + addG;
        int b = SourceColor.getBlue() + addB;
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public int RGBtoCPC(int src, boolean plus) {
        if (!plus) {
            return src < this.dark ? 0 : (src < this.medium ? 125 : 255);
        }
        return src;
    }

    public void findCPCInk(Color test2) {
        this.RedPixel = test2.getRed() & 0xFF;
        this.GreenPixel = test2.getGreen() & 0xFF;
        this.BluePixel = test2.getBlue() & 0xFF;
        if (!green) {
            this.CPCRed = this.RGBtoCPC(this.RedPixel, plusmode);
            this.CPCGreen = this.RGBtoCPC(this.GreenPixel, plusmode);
            this.CPCBlue = this.RGBtoCPC(this.BluePixel, plusmode);
        } else {
            this.CPCRed = this.RedPixel;
            this.CPCGreen = this.GreenPixel;
            this.CPCBlue = this.BluePixel;
        }
    }

    public void setPlusINK(int value) {
        this.setPlusINK(this.pen, value);
    }

    public void setPlusINK(int pen, int value) {
        CPC.Palcols[pen] = new Color(value);
        OverscanCanvas.GateArrayColors[pen] = value;
        GateArray.setPalette(pen, value);
        CPC.inksEdited = false;
    }

    public void setINK(int value) {
        this.setINK(this.pen, value);
    }

    public void setINK(int pen, int value) {
        Color col = new Color(value);
        this.findCPCInk(col);
        for (int i = 0; i < CPC.Palcols.length; ++i) {
            int B;
            int G;
            int R;
            int r = CPC.Palcols[i].getRed();
            int g = CPC.Palcols[i].getGreen();
            int b = CPC.Palcols[i].getBlue();
            if (!green) {
                R = this.RGBtoCPC(col.getRed(), false);
                G = this.RGBtoCPC(col.getGreen(), false);
                B = this.RGBtoCPC(col.getBlue(), false);
            } else {
                r = CPC.Greencols[i].getRed();
                g = CPC.Greencols[i].getGreen();
                b = CPC.Greencols[i].getBlue();
                R = col.getRed();
                G = col.getGreen();
                B = col.getBlue();
                int d = R + G + B;
                R = d /= 3;
                G = d;
                B = d;
            }
            if (r < R - 10 || r > R + 10 || g < G - 10 || g > G + 10 || b < B - 10 || b > B + 10) continue;
            OverscanCanvas.INK(pen, i);
            break;
        }
    }

    protected BufferedImage prepareInput(BufferedImage input) {
        if (this.rasterval < 181 && !plusmode) {
            this.pseudo.getGraphics().drawImage(input, 0, 0, 768, 544, this);
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int nw = this.mode == 2 ? 768 : (this.mode == 1 ? 384 : 192);
        int nh = 272;
        BufferedImage bb = new BufferedImage(nw, nh, 1);
        bb.createGraphics().drawImage(input, 0, 0, nw, nh, null);
        int xstep = 1;
        if (this.mode == 1) {
            xstep = 2;
        }
        if (this.mode == 0) {
            xstep = 4;
        }
        input.createGraphics().drawImage(bb, 0, 0, width, height, null);
        this.showImage.getGraphics().drawImage(input, 0, 0, 384, 272, this);
        return input;
    }

    protected void buildCPCPalette(BufferedImage input) {
        int j;
        int q;
        int i;
        if (input == null) {
            return;
        }
        Graphics v = input.getGraphics();
        int tolerance = ImageProcessor.tolerance.getValue() / 10 + 1;
        this.mode = GateArray.getSMode();
        overscanPaint.output.append("Process pass 1...\n");
        int width = input.getWidth();
        int height = input.getHeight();
        int xstep = 1;
        if (width > 768) {
            width = 768;
        }
        if (height > 544) {
            height = 544;
        }
        if (this.mode == 1) {
            xstep = 2;
        }
        if (this.mode == 0) {
            xstep = 4;
        }
        int keeppen = this.pen;
        this.palcount = new int[27];
        if (plusmode) {
            int i6;
            int i5;
            int i2;
            for (int k = 0; k < 4096; ++k) {
                this.used[k] = 0;
            }
            if (this.addr != 0 || this.addg != 0 || this.addb != 0) {
                this.ManipulateRGB(input);
            }
            int offset = 0;
            int having = 0;
            int toldiv = ImageProcessor.divider.getValue() / 5 + 1;
            int tol = 0;
            boolean put = false;
            overscanPaint.output.append("Tolerance is " + tolerance + "\n");
            for (int n = 0; n < width; n += tolerance * xstep) {
                for (int ydot = 0; ydot < height; ydot += tolerance * 2) {
                    if (!ImageProcessor.method.isSelected() && !ImageProcessor.method1.isSelected()) {
                        if (++tol >= toldiv) {
                            tol = 0;
                            put = true;
                        }
                    } else {
                        put = true;
                    }
                    if (put) {
                        int col = input.getRGB(n, ydot);
                        int[] rgb = this.getRGB(col);
                        int r = GateArray.LUM(rgb[0] >> 4);
                        int i62 = GateArray.LUM(rgb[1] >> 4);
                        int b = GateArray.LUM(rgb[2] >> 4);
                        int value = GateArray.putRGB(r, i62, b);
                        for (int i7 = 0; i7 < 4096; ++i7) {
                            if (i7 == 6000 || this.colours[i7] != value) continue;
                            this.used[i7] = this.used[i7] + 1;
                            i7 = 6000;
                        }
                    }
                    put = false;
                }
            }
            for (int m = 0; m < 4096; ++m) {
                if (this.used[m] == 0) continue;
                ++having;
            }
            overscanPaint.output.append("Colours found: " + having + "\n");
            int d = 16;
            if (this.mode == 1) {
                d = 4;
            }
            int div = having >= d ? having / d : having;
            int divider = ImageProcessor.divider.getValue() / 10 + 1;
            int[] pal = new int[16];
            int[] havingcol = new int[4096];
            int[] haveused = new int[4096];
            int hoffset = 0;
            int pos = 0;
            int[] colli = new int[having];
            for (int i1 = 0; i1 < 4096; ++i1) {
                if (this.used[i1] == 0) continue;
                ++pos;
                haveused[hoffset] = this.used[i1];
                havingcol[hoffset] = this.colours[i1];
                colli[hoffset++] = this.colours[i1];
            }
            int hoff = 0;
            int yoff = 0;
            String[] foof = new String[having];
            for (i2 = 0; i2 < having; ++i2) {
                foof[i2] = "" + Util.hex(colli[i2]);
            }
            Collections.sort(Arrays.asList((Comparable[])foof));
            for (i2 = 0; i2 < having; ++i2) {
                try {
                    colli[i2] = Util.hexValue(foof[i2]);
                    continue;
                }
                catch (Exception r) {
                    break;
                }
            }
            this.pali = new BufferedImage(having * 16, 16, 1);
            System.arraycopy(colli, 0, havingcol, 0, colli.length);
            Graphics2D g = this.pali.createGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, having * 16, 16);
            for (int i3 = 0; i3 < having; ++i3) {
                g.setColor(new Color(colli[i3]));
                g.fillRect(hoff, yoff, 16, 16);
                hoff += 16;
            }
            QuantizeFilter cop = new QuantizeFilter();
            cop.setDither(false);
            cop.setSerpentine(false);
            cop.setNumColors(16);
            System.out.println("Having " + having + " colors");
            cop.filter(this.pali, this.pali);
            int[] ppal = new int[16];
            for (int i4 = 0; i4 < 16; ++i4) {
                ppal[i4] = -1;
            }
            int vpos = 0;
            for (i5 = 0; i5 < having; ++i5) {
                int value = this.pali.getRGB(i5 * 16, 8);
                put = true;
                for (int gg = 0; gg < 16; ++gg) {
                    if (ppal[gg] != value) continue;
                    put = false;
                    break;
                }
                if (!put) continue;
                ppal[vpos++] = value;
            }
            offset = 0;
            if (ImageProcessor.method1.isSelected()) {
                int dd = having / divider / 16;
                ++dd;
                for (i6 = 0; i6 < 16; ++i6) {
                    pal[i6] = havingcol[offset];
                    try {
                        offset += pos / 2 / pos / 2 / dd * divider;
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                int[] buff = new int[16];
                System.arraycopy(pal, 0, buff, 0, 16);
                for (int i7 = 0; i7 < 16; ++i7) {
                    pal[i7] = buff[this.pals[i7]];
                }
            } else if (!ImageProcessor.method.isSelected()) {
                System.arraycopy(ppal, 0, pal, 0, 16);
                int[] buff = new int[16];
                System.arraycopy(pal, 0, buff, 0, 16);
                for (i6 = 0; i6 < 16; ++i6) {
                    pal[i6] = buff[this.pals[i6]];
                }
            } else {
                for (i5 = 0; i5 < having; i5 += div / divider) {
                    if (haveused[i5] == -1) continue;
                    try {
                        pal[offset] = havingcol[i5];
                        ++offset;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (offset != 16) {
                        continue;
                    }
                    break;
                }
            }
            if (ImageProcessor.ordered.isSelected()) {
                Arrays.sort(pal);
            }
            for (i5 = 0; i5 < 16; ++i5) {
                if (!this.lockPEN[i5]) {
                    this.setPlusINK(i5 & 0xF, pal[i5 & 0xF]);
                }
                OverscanCanvas.INK(i5 & 0xF, i5 & 0xF);
            }
            return;
        }
        for (int xdot = 0; xdot < width; xdot += xstep) {
            for (int ydot = 0; ydot < height; ydot += 2) {
                Color test2 = new Color(input.getRGB(xdot, ydot));
                this.findCPCInk(test2);
                Color CPCPen = new Color(this.CPCRed, this.CPCGreen, this.CPCBlue);
                for (int k = 0; k < 27; ++k) {
                    if (this.getCOL(this.Col[k]) != this.getCOL(CPCPen)) continue;
                    this.palcount[k] = this.palcount[k] + 1;
                }
            }
        }
        this.count = 0;
        int[] check = new int[27];
        int number = 0;
        for (int p = 0; p < 27; ++p) {
            if (this.palcount[p] != 0) {
                ++number;
            }
            check[p] = this.palcount[p];
        }
        overscanPaint.output.append(number + " INKs found.\n");
        Arrays.sort(check);
        int[] recheck = new int[27];
        int collect = 16;
        this.outcount = new int[collect];
        for (i = 0; i < 27; ++i) {
            recheck[i] = check[26 - i];
        }
        check = recheck;
        block28: for (i = 0; i < 27; ++i) {
            for (q = 0; q < 27; ++q) {
                if (this.palcount[q] == check[i]) {
                    this.outcount[this.count++] = q;
                }
                if (this.count == collect) continue block28;
            }
        }
        for (i = 0; i < 27; ++i) {
            this.realInks[i] = -1;
        }
        for (i = 0; i < 27; ++i) {
            for (q = 0; q < 27; ++q) {
                if (this.palcount[q] != check[i]) continue;
                this.realInks[i] = q;
            }
        }
        if (ImageProcessor.ordered.isSelected() && !plusmode) {
            Arrays.sort(this.outcount);
        }
        this.counted = new int[collect];
        for (int pf = 0; pf < 16; ++pf) {
            if (this.lockPEN[pf]) continue;
            OverscanCanvas.INK(pf, 0);
        }
        String outtext = "Palette: ";
        int max = this.mode == 0 ? 16 : (this.mode == 1 ? 4 : 2);
        for (j = 0; j < collect; ++j) {
            if (!this.lockPEN[j]) {
                OverscanCanvas.INK(j, this.outcount[j]);
            }
            if (j < max) {
                outtext = outtext + this.outcount[j];
            }
            this.counted[j] = this.outcount[j];
            if (j >= collect - 1 || j >= max) continue;
            outtext = outtext + ",";
        }
        overscanPaint.output.append("Process pass 2...\n");
        outtext = outtext + "\n";
        for (j = 0; j < max; ++j) {
            outtext = outtext + this.cpccolors[this.outcount[j]];
            if (j >= max - 1) continue;
            outtext = outtext + ",";
        }
        overscanPaint.output.append(outtext + "\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.pen = keeppen;
    }

    public void checkLoadImg() {
        int checksum = 0;
        for (int xdot = 0; xdot < this.loadedImage.getWidth(); xdot += 10) {
            for (int ydot = 0; ydot < this.loadedImage.getHeight(); ydot += 10) {
                Color test2 = new Color(this.loadedImage.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
        if (checksum == 0) {
            this.convertScreen(this.loadname);
        }
    }

    public void checkImage() {
        int checksum = 0;
        for (int xdot = 0; xdot < this.scrollImage.getWidth(); xdot += 10) {
            for (int ydot = 0; ydot < this.scrollImage.getHeight(); ydot += 10) {
                Color test2 = new Color(this.scrollImage.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
        if (checksum == 0) {
            this.convertScreen(this.loadname);
        }
    }

    public void savescreen(BufferedImage ima, String filename, String filetype) {
        try {
            File file = new File(filename);
            ImageIO.write((RenderedImage)ima, filetype, file);
        }
        catch (Exception e) {
            System.out.println("Error while writing image " + filename + ":");
            System.out.println(e.getMessage());
        }
    }

    public void Autostore() {
        try {
            String append = "";
            if (this.autoIndex < 100) {
                append = append + "0";
            }
            if (this.autoIndex < 10) {
                append = append + "0";
            }
            append = append + "" + this.autoIndex++;
            File file = new File("store_" + append + ".bmp");
            ImageIO.write((RenderedImage)this.outimage, "bmp", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convert(boolean detect) {
        boolean detectIt;
        if (this.scr) {
            return;
        }
        this.scr = false;
        if (this.keepinks) {
            detect = false;
        }
        if (ImageProcessor.method2.getValue() != 0) {
            this.preCalculate(this.paletteMethod ? this.loadedImage : this.CPCImage, ImageProcessor.method2.getValue());
        }
        this.showImage.getGraphics().drawImage(this.loadedImage, 0, 0, 384, 272, this);
        boolean bl = detectIt = detect && !this.detected;
        if (detectIt) {
            System.out.println("Calculating palette...");
        }
        this.refactorImage(detectIt);
        if (detectIt) {
            recalculate = 1;
            this.detected = true;
            return;
        }
        if (this.CPCImage == null) {
            return;
        }
        int width = this.CPCImage.getWidth();
        for (int y = 0; y < 272; ++y) {
            block1: for (int x = 0; x < width; ++x) {
                Color test2 = new Color(this.CPCImage.getRGB(x, y));
                this.findCPCInk(test2);
                Color CPCPen = new Color(this.CPCRed, this.CPCGreen, this.CPCBlue);
                for (int p = 0; p < 16; ++p) {
                    if (this.getCOL(this.getColor(p)) != this.getCOL(CPCPen)) continue;
                    this.plot(x, y, p & 0xF);
                    continue block1;
                }
            }
        }
    }

    public int replaceInk(int[] inInk) {
        int outInk = this.realInks[this.pen];
        int cols = 16;
        if (this.mode == 1) {
            cols = 4;
        }
        if (this.mode == 2) {
            cols = 2;
        }
        for (int c = 0; c < inInk.length; ++c) {
            for (int pn = 0; pn < cols; ++pn) {
                if (this.realInks[pn] != inInk[c]) continue;
                outInk = inInk[c];
                return outInk;
            }
        }
        return outInk;
    }

    public Color getCol(int index) {
        if (green) {
            return CPC.Greencols[index];
        }
        return CPC.Palcols[index];
    }

    public Color getColor(int index) {
        if (green) {
            return CPC.Greencols[GateArray.getInk(index)];
        }
        return CPC.Palcols[GateArray.getInk(index)];
    }

    public void clear() {
        for (int i = 0; i < 31936; ++i) {
            GateArray.screenmemory[512 + i] = 0;
        }
        filled = 1;
    }

    public void putScreen() {
        if (this.filling) {
            return;
        }
        Graphics page = this.getGraphics();
        this.sourceImage = new BufferedImage(768, 544, 1);
        if (this.zoomit) {
            page.setColor(Color.MAGENTA);
            page.fillRect(0, 0, 800, 600);
            page.drawImage(Display.image, 0 - this.xoffset * this.zoomvalue, 0 - this.yoffset * this.zoomvalue, 768 * this.zoomvalue, 544 * this.zoomvalue, this);
            this.sourceImage.getGraphics().drawImage(Display.image, 0 - this.xoffset * this.zoomvalue, 0 - this.yoffset * this.zoomvalue, 768 * this.zoomvalue, 544 * this.zoomvalue, this);
        } else {
            page.drawImage(Display.image, 0, 0, 768, 544, this);
            this.sourceImage.getGraphics().drawImage(Display.image, 0, 0, 768, 544, this);
        }
        if (this.mode == 0) {
            this.outimage = new BufferedImage(192, 272, 1);
        }
        if (this.mode == 1) {
            this.outimage = new BufferedImage(384, 272, 1);
        }
        if (this.mode == 2) {
            this.outimage = new BufferedImage(768, 272, 1);
        }
        this.outimage.getGraphics().drawImage(this.sourceImage, 0, 0, this.outimage.getWidth(), 272, this);
        overscanPaint.reset();
    }

    public void buildScreen(BufferedImage image) {
        for (int x = 0; x < 768; ++x) {
            for (int y = 0; y < 544; ++y) {
                Color test2 = new Color(image.getRGB(x, y));
                Color testb = CPC.getCol(this.pen);
                if (green) {
                    testb = CPC.getGCol(this.pen);
                }
                if (this.getCOL(test2) != this.getCOL(testb)) continue;
                int cpcX = x;
                int cpcY = y / 2;
                if (this.mode == 0) {
                    cpcX /= 4;
                }
                if (this.mode == 1) {
                    cpcX /= 2;
                }
                this.plot(cpcX, cpcY, this.pen);
            }
        }
    }

    public void putText() {
        BufferedImage off_Image = new BufferedImage(768, 544, 1);
        Graphics2D page = off_Image.createGraphics();
        page.setColor(new Color(255, 113, 222));
        page.fillRect(0, 0, 768, 544);
        page.setFont(new Font(this.fontname, 0 + this.italic + this.bold, Integer.parseInt(overscanPaint.textsize.getText())));
        if (green) {
            page.setColor(CPC.getGCol(this.pen));
        } else {
            page.setColor(CPC.getCol(this.pen));
        }
        ((Graphics)page).drawString(overscanPaint.text.getText(), this.textX, this.textY);
        this.buildScreen(off_Image);
    }

    public void putObject(int number) {
        BufferedImage off_Image = new BufferedImage(768, 544, 1);
        Graphics2D page = off_Image.createGraphics();
        page.setColor(new Color(255, 113, 222));
        page.fillRect(0, 0, 768, 544);
        if (green) {
            page.setColor(CPC.getGCol(this.pen));
        } else {
            page.setColor(CPC.getCol(this.pen));
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        this.lineX = this.lineX / xs * xs;
        this.lineY = this.lineY / ys * ys;
        int fromx = this.lineX;
        int fromy = this.lineY;
        int tox = this.toX - this.lineX;
        int toy = this.toY - this.lineY;
        if (this.toX < this.lineX) {
            fromx = this.toX;
            tox = this.lineX - this.toX;
        } else {
            fromx = this.lineX;
            tox = this.toX - this.lineX;
        }
        if (this.toY < this.lineY) {
            fromy = this.toY;
            toy = this.lineY - this.toY;
        } else {
            fromy = this.lineY;
            toy = this.toY - this.lineY;
        }
        tox = tox / xs * xs;
        toy = toy / ys * ys;
        if (number == 1) {
            page.drawLine(this.lineX, this.lineY, this.toX, this.toY);
        }
        if (number == 2) {
            page.drawRect(fromx, fromy, tox, toy);
        }
        if (number == 3) {
            page.drawOval(fromx, fromy, tox, toy);
        }
        if (number == 4) {
            page.fillRect(fromx, fromy, tox + xs, toy + ys);
        }
        if (number == 5) {
            page.fillOval(fromx, fromy, tox + xs, toy + ys);
        }
        this.buildScreen(off_Image);
    }

    public void copyShape() {
        if (this.shapeW <= 0 || this.shapeH <= 0) {
            return;
        }
        this.putScreen();
        BufferedImage buffimg = new BufferedImage(768, 544, 1);
        if (JEMU.large) {
            buffimg.getGraphics().drawImage(Display.image, 0, 0, 768, 544, this);
        } else {
            buffimg.getGraphics().drawImage(Display.image, 0, 0, 544, 544, this);
        }
        this.shapeBrush = new BufferedImage(this.shapeW, this.shapeH, 1);
        this.shapeBrush.getGraphics().drawImage(buffimg, 0 - this.shapeX, 0 - this.shapeY, this.shapeW, this.shapeH, 0, 0, this.shapeW + this.shapeX, this.shapeH + this.shapeY, this);
        int checksum = 0;
        for (int xdot = 0; xdot < this.shapeBrush.getWidth(); xdot += 2) {
            for (int ydot = 0; ydot < this.shapeBrush.getHeight(); ydot += 2) {
                Color test2 = new Color(this.shapeBrush.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
    }

    public void showShape(int x, int y) {
        if (this.shapeBrush == null) {
            return;
        }
        this.putScreen();
        Graphics page = this.getGraphics();
        page.drawImage(this.shapeBrush, x, y, this);
    }

    public void buildShape(int xpos, int ypos) {
        for (int pf = 0; pf < 27; ++pf) {
            this.Col[pf] = green ? new Color(GateArrayGreens[pf]) : new Color(GateArrayColors[pf]);
        }
        if (this.shapeBrush == null) {
            return;
        }
        int xs = 4;
        int ys = 2;
        int pns = 16;
        if (this.mode == 1) {
            xs = 2;
            pns = 4;
        }
        if (this.mode == 2) {
            xs = 1;
            pns = 2;
        }
        for (int x = 0; x < this.shapeBrush.getWidth(); x += xs) {
            for (int y = 0; y < this.shapeBrush.getHeight(); y += ys) {
                for (int pn = 0; pn < pns; ++pn) {
                    Color test2 = new Color(this.shapeBrush.getRGB(x, y));
                    Color testb = this.Col[GateArray.getInk(pn)];
                    int plusminus = 64;
                    if (plusmode) {
                        plusminus = 2;
                    }
                    if ((green || test2.getBlue() < testb.getBlue() - plusminus || test2.getBlue() > testb.getBlue() + plusminus || test2.getGreen() < testb.getGreen() - plusminus || test2.getGreen() > testb.getGreen() + plusminus || test2.getRed() < testb.getRed() - plusminus || test2.getRed() > testb.getRed() + plusminus) && (!green || test2.getGreen() < testb.getGreen() - 4 || test2.getGreen() > testb.getGreen() + 4)) continue;
                    int cpcX = x + xpos;
                    int cpcY = (y + ypos) / 2;
                    if (this.mode == 0) {
                        cpcX /= 4;
                    }
                    if (this.mode == 1) {
                        cpcX /= 2;
                    }
                    try {
                        if (pn == this.transpen) continue;
                        this.plot(cpcX, cpcY, pn);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void addX() {
        int xs = 1;
        if (this.mode == 1) {
            xs = 2;
        }
        if (this.mode == 0) {
            xs = 4;
        }
        this.xoffset += xs;
        this.putScreen();
    }

    public void addY() {
        this.yoffset += 2;
        this.putScreen();
    }

    public void subX() {
        if (this.mode == 1) {
            this.xoffset -= 2;
        }
        if (this.mode == 2) {
            --this.xoffset;
        }
        if (this.mode == 0) {
            this.xoffset -= 4;
        }
        this.putScreen();
    }

    public void subY() {
        this.yoffset -= 2;
        this.putScreen();
    }

    public void defineZoom(int x, int y) {
        this.xoffset = x - 768 / this.zoomvalue / 2;
        this.yoffset = y - 544 / this.zoomvalue / 2;
        if (this.xoffset < 0) {
            this.xoffset = 0;
        }
        if (this.yoffset < 0) {
            this.yoffset = 0;
        }
        while (this.xoffset + 768 / this.zoomvalue > 768) {
            --this.xoffset;
        }
        while (this.yoffset + 544 / this.zoomvalue > 544) {
            --this.yoffset;
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        this.xoffset = this.xoffset / xs * this.zoomvalue * xs * this.zoomvalue;
        this.yoffset = this.yoffset / ys * this.zoomvalue * ys * this.zoomvalue;
        this.zoomit = true;
    }

    public void removeZoom() {
        this.zoomit = false;
        this.setzoom = false;
    }

    public void doZoom() {
        if (this.zoomit) {
            return;
        }
        this.setzoom = true;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int yc;
        int xc;
        this.mousebutton = event.getButton();
        if (this.setzoom) {
            this.setzoom = false;
            this.defineZoom(event.getX(), event.getY());
            return;
        }
        if (this.zoomit && this.mousebutton != 1) {
            return;
        }
        System.gc();
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        int gotX = event.getX();
        int gotY = event.getY();
        if (this.zoomit) {
            xc = gotX / xs * this.zoomvalue * xs * this.zoomvalue;
            yc = gotY / ys * this.zoomvalue * ys * this.zoomvalue;
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        if (this.MODE == this.MODE_MINITEXT) {
            this.putText(xc, yc);
        }
        if (this.MODE == this.MODE_TEXT) {
            this.putText();
        }
        if (this.MODE == this.MODE_LINE) {
            this.putObject(1);
        }
        if (this.MODE == this.MODE_RECTANGLE) {
            this.putObject(2);
        }
        if (this.MODE == this.MODE_CIRCLE) {
            this.putObject(3);
        }
        if (this.MODE == this.MODE_FRECT) {
            this.putObject(4);
        }
        if (this.MODE == this.MODE_FILL) {
            this.Fill(xc, yc, null, this.commandInt > 0);
            filled = 1;
        }
        if (this.MODE == this.MODE_FCIRCLE) {
            this.putObject(5);
        }
        if (this.MODE == this.MODE_COPY) {
            this.copyShape();
            this.MODE = this.MODE_PASTE;
        } else if (this.MODE == this.MODE_PASTE && this.shapeBrush != null) {
            if (xc >= 768 - this.shapeBrush.getWidth()) {
                xc = 768 - this.shapeBrush.getWidth();
            }
            if (yc >= 544 - this.shapeBrush.getHeight()) {
                yc = 544 - this.shapeBrush.getHeight();
            }
            this.buildShape(xc, yc);
        }
        this.putScreen();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.mousebutton = event.getButton();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.paint = true;
        this.setIcon(null);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.paint = false;
        try {
            this.setIcon(new ImageIcon(this.sourceImage));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getPlus() {
        return plusmode;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int yc;
        int xc;
        if (this.MODE == this.MODE_FILL && this.filling) {
            return;
        }
        if (this.setzoom) {
            int x = event.getX();
            int y = event.getY();
            int i = 1;
            int j = 2;
            if (this.mode == 0) {
                i = 4;
            }
            if (this.mode == 1) {
                i = 2;
            }
            x = x / i * this.zoomvalue * i * this.zoomvalue;
            y = y / j * this.zoomvalue * j * this.zoomvalue;
            this.putScreen();
            Graphics graphics = this.getGraphics();
            graphics.setColor(new Color(Util.random(0xFFFFFF)));
            int px = x - 768 / this.zoomvalue / 2;
            int py = y - 544 / this.zoomvalue / 2;
            px = px / i * this.zoomvalue * i * this.zoomvalue;
            py = py / j * this.zoomvalue * j * this.zoomvalue;
            graphics.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        if (recalculate != 0) {
            return;
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        int gotX = event.getX();
        int gotY = event.getY();
        if (this.zoomit) {
            xc = gotX / xs * this.zoomvalue * xs * this.zoomvalue;
            yc = gotY / ys * this.zoomvalue * ys * this.zoomvalue;
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        this.zoomx = gotX;
        this.zoomy = gotY;
        filled = 0;
        this.putScreen();
        Graphics page = this.getGraphics();
        if (this.MODE == this.MODE_MINITEXT) {
            Color check = green ? CPC.getGCol(this.textpen) : CPC.getCol(this.textpen);
            page.setColor(new Color(check.getRed(), check.getGreen(), check.getBlue(), 128));
            if (this.zoomit) {
                page.fillRect(xc, yc, this.minisize * this.zoomvalue, 10 * this.zoomvalue);
            } else {
                page.fillRect(xc, yc, this.minisize, 10);
            }
        }
        if (this.MODE == this.MODE_PAINT || this.MODE == this.MODE_LINE) {
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            this.painted = true;
        }
        if (this.MODE == this.MODE_CIRCLE || this.MODE == this.MODE_FCIRCLE || this.MODE == this.MODE_COPY || this.MODE == this.MODE_RECTANGLE || this.MODE == this.MODE_FRECT) {
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            this.cross(xc, yc);
            this.painted = true;
        }
        if (this.MODE == this.MODE_PASTE && this.shapeBrush != null) {
            if (xc >= 768 - this.shapeBrush.getWidth()) {
                xc = 768 - this.shapeBrush.getWidth();
            }
            if (yc >= 544 - this.shapeBrush.getHeight()) {
                yc = 544 - this.shapeBrush.getHeight();
            }
            this.showShape(xc, yc);
        }
        if (this.MODE == this.MODE_TEXT) {
            this.putScreen();
            this.textX = gotX / xs * xs;
            this.textY = gotY / ys * ys;
            page.setFont(new Font(this.fontname, 0 + this.italic + this.bold, Integer.parseInt(overscanPaint.textsize.getText())));
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            page.drawString(overscanPaint.text.getText(), this.textX, this.textY);
        }
        this.drawCross(xc, yc, xs, ys);
    }

    public void drawCross(int xc, int yc, int xs, int ys) {
        Graphics page = this.getGraphics();
        boolean bl = this.flip = !this.flip;
        if (this.flip) {
            page.setColor(this.crossfade1);
        } else {
            page.setColor(this.crossfade2);
        }
        if (this.zoomit) {
            page.fillRect(xc, yc + 6 * this.zoomvalue, xs * this.zoomvalue, 10 * this.zoomvalue);
            page.fillRect(xc, yc - 14 * this.zoomvalue, xs * this.zoomvalue, 10 * this.zoomvalue);
            page.fillRect(xc + 6 * this.zoomvalue, yc, xs + 10 * this.zoomvalue, ys * this.zoomvalue);
            page.fillRect(xc - 16 * this.zoomvalue, yc, xs + 10 * this.zoomvalue, ys * this.zoomvalue);
            page.setColor(CPC.getCol(this.pen));
            page.fillRect(xc, yc, xs * this.zoomvalue, ys * this.zoomvalue);
        } else {
            page.fillRect(xc, yc + 6, xs, 10);
            page.fillRect(xc, yc - 14, xs, 10);
            page.fillRect(xc + 6, yc, xs + 10, ys);
            page.fillRect(xc - 16, yc, xs + 10, ys);
            page.setColor(CPC.getCol(this.pen));
            page.fillRect(xc, yc, xs, ys);
        }
    }

    public void cross(int xc, int yc) {
        Graphics page = this.getGraphics();
        page.setColor(this.random);
        page.drawLine(0, yc, 768, yc);
        page.drawLine(0, yc + 1, 768, yc + 1);
        page.drawLine(xc, 0, xc, 544);
        if (this.mode == 1 || this.mode == 0) {
            page.drawLine(xc + 1, 0, xc + 1, 544);
        }
        if (this.mode == 0) {
            page.drawLine(xc + 2, 0, xc + 2, 544);
            page.drawLine(xc + 3, 0, xc + 3, 544);
        }
    }

    public void cycle() {
        Switches.monitormode = green ? 2 : 0;
        if (this.showImage != null && overscanPaint.noMouse) {
            Graphics g = this.bzm.getGraphics();
            g.drawImage(this.showImage, 0, 0, 384, 272, this);
            overscanPaint.proc.image.setIcon(new ImageIcon(this.bzm));
        }
        if (autostore) {
            this.Autostore();
            autostore = false;
        }
        if (!this.isVisible()) {
            System.err.println("paint is cycling:" + this.cycles++);
        }
        ++this.reset;
        if (this.reset > 200) {
            this.reset = 0;
            overscanPaint.reset();
        }
        if (this.importname != null) {
            ++this.importscr;
            if (this.importscr == 40) {
                CPC.POKE(36863, 3);
            }
            if (this.importscr == 70) {
                this.convertScreen(this.importname);
                this.MODE = this.MODE_IMPORT;
                this.loadname = this.importname;
                this.importname = null;
                this.importscr = 0;
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
            }
        }
        this.random = new Color(Util.random(255), Util.random(255), Util.random(255));
        if (filled > 0 && ++filled >= 20) {
            filled = 0;
            this.putScreen();
            overscanPaint.reset();
        }
        if (this.checkPal > 0) {
            if (this.checkPal < 50) {
                ++this.checkPal;
            } else if (!GateArray.cpc.floppymotor) {
                ++this.checkPal;
            }
            if (this.checkPal == 60) {
                this.setPal();
                filled = 1;
            }
            if (this.checkPal == 70) {
                this.checkPal = 0;
            }
            this.putScreen();
        }
        if (this.doCycle) {
            if (this.MODE != this.MODE_IMPORT) {
                overscanPaint.ScrollUpDown.setEnabled(false);
                overscanPaint.ScrollLeftRight.setEnabled(false);
            } else {
                overscanPaint.ScrollUpDown.setEnabled(true);
                overscanPaint.ScrollLeftRight.setEnabled(true);
            }
            if (recalculate > 0) {
                if (++recalculate == 20) {
                    this.recalculate();
                    this.convert(true);
                }
                if (recalculate == 40) {
                    recalculate = 0;
                    overscanPaint.output.append("Size viewed: 768x544, ratio = 1.4117647 Origin : (" + this.scroll + "," + this.scrollb + ")\n");
                    overscanPaint.output.select(2000000000, 2000000000);
                    filled = 1;
                }
            }
            if (this.cycled > 0) {
                ++this.cycled;
                if (this.cycled == 10) {
                    this.convert(true);
                }
                if (this.cycled == 20) {
                    filled = 1;
                    this.cycled = 0;
                }
            }
        }
        this.mode = GateArray.getSMode();
    }

    public void makeUndo() {
        for (int y = 0; y < 31936; ++y) {
            this.undo[y] = GateArray.screenmemory[512 + y];
        }
    }

    public static void INK(int pen, int ink) {
        int addressA = 45529;
        int addressB = 45546;
        if (Switches.ROM.equals("CPC6128") || Switches.ROM.equals("CPC664")) {
            addressA = 47060;
            addressB = 47077;
        }
        CPC.POKE(addressA + 1 + pen, GateArrayINKs[ink]);
        CPC.POKE(addressB + 1 + pen, GateArrayINKs[ink]);
    }

    public void Undo() {
        for (int y = 0; y < 31936; ++y) {
            GateArray.screenmemory[512 + y] = (byte)this.undo[y];
        }
        filled = 1;
    }

    public void DSKLoad() {
        int y;
        JComboBox<String> filelist = new JComboBox<String>();
        filelist.setFont(new Font("Monospaced", 1, 12));
        String[] files = overscanPaint.files;
        for (y = 0; y < files.length; ++y) {
            files[y] = files[y].substring(0, 12);
        }
        for (y = 0; y < files.length; ++y) {
            if (!files[y].endsWith("SCR") && !files[y].endsWith("BIN")) continue;
            filelist.addItem(files[y]);
        }
        if (filelist.getItemAt(0) == null) {
            return;
        }
        Object[] object = new Object[]{filelist, this.restorePal};
        int selectedValue = JOptionPane.showOptionDialog(this, object, "Choose file:", 2, 2, null, null, null);
        if (selectedValue != 0) {
            return;
        }
        try {
            String lname = filelist.getSelectedItem().toString();
            byte[] load = lname.getBytes("UTF-8");
            for (int i = 923; i < 935; ++i) {
                CPC.POKE(36864 + i, load[i - 923]);
            }
            CPC.POKE(36863, 10);
            if (this.resPal) {
                this.checkPal = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPal() {
        OverscanCanvas.resetCPCColours();
        System.out.println("setPal:" + Util.hex(GateArray.screenmemory[2081]));
        plusmode = GateArray.screenmemory[2081] == -13;
        ImageProcessor.OVERRIDE = true;
        if (plusmode) {
            ImageProcessor.plus.setSelected(true);
            ImageProcessor.divider.setEnabled(true);
            ImageProcessor.dlabel.setEnabled(true);
        } else {
            ImageProcessor.plus.setSelected(false);
            ImageProcessor.divider.setEnabled(false);
            ImageProcessor.dlabel.setEnabled(false);
        }
        ImageProcessor.OVERRIDE = false;
        if (plusmode) {
            this.makePlus(GateArray.screenmemory, 512);
        } else {
            int i;
            int checksum = 0;
            for (i = 0; i < 16; ++i) {
                checksum += GateArray.screenmemory[2049 + i];
            }
            if (checksum != 0) {
                for (i = 0; i < 16; ++i) {
                    OverscanCanvas.INK(i, GateArray.screenmemory[2049 + i]);
                }
                checksum = GateArray.screenmemory[2048];
                if (checksum == 0) {
                    checksum = 3;
                }
                CPC.POKE(36863, checksum);
            }
        }
        this.putScreen();
    }

    public void minitext() {
        String[] pena = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        String[] penb = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "Off"};
        String[] transb = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "Transparent"};
        JPanel pen1 = new JPanel();
        pen1.setLayout(new FlowLayout(2, 1, 2));
        JPanel pen2 = new JPanel();
        pen2.setLayout(new FlowLayout(2, 1, 2));
        JPanel backg = new JPanel();
        backg.setLayout(new FlowLayout(2, 1, 2));
        JComboBox<String> penA = new JComboBox<String>(pena);
        JComboBox<String> penB = new JComboBox<String>(penb);
        JComboBox<String> transB = new JComboBox<String>(transb);
        penA.setSelectedIndex(this.textpen);
        penB.setSelectedIndex(this.smoothpen);
        transB.setSelectedIndex(this.transback);
        if (this.mode == 2) {
            penB.setEnabled(false);
            penB.setSelectedIndex(16);
        }
        JLabel penaa = new JLabel("Text-PEN    ");
        JLabel penbb = new JLabel("Smooth-PEN    ");
        JLabel transbb = new JLabel("Background    ");
        backg.add(transbb);
        backg.add(transB);
        pen1.add(penaa);
        pen1.add(penA);
        pen2.add(penbb);
        pen2.add(penB);
        JTextField inputtext = new JTextField();
        inputtext.setText(this.minitext);
        Object[] object = new Object[]{inputtext, pen1, pen2, backg};
        int selectedValue = JOptionPane.showOptionDialog(this, object, "Enter mini-text:", 2, 2, null, null, null);
        if (selectedValue != 0) {
            return;
        }
        try {
            int pn1 = Integer.parseInt(penA.getSelectedItem().toString());
            String pn2s = penB.getSelectedItem().toString();
            String pn3s = transB.getSelectedItem().toString();
            int pn2 = 0;
            int pn3 = 0;
            pn2 = pn2s.equals("Off") ? 16 : Integer.parseInt(penB.getSelectedItem().toString());
            pn3 = pn3s.equals("Transparent") ? 16 : Integer.parseInt(transB.getSelectedItem().toString());
            String enteredText = inputtext.getText();
            this.createText(pn1, pn2, pn3, enteredText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createText(int pen1, int pen2, int pen3, String text) {
        this.textpen = pen1;
        this.smoothpen = pen2;
        this.transback = pen3;
        this.minitext = text;
        text = text.toUpperCase();
        this.output = new String[text.length()];
        for (int i = 0; i < this.output.length; ++i) {
            this.output[i] = text.substring(i, i + 1);
        }
        this.minisize = this.output.length * 5;
        if (this.mode == 1) {
            this.minisize *= 2;
        }
        if (this.mode == 0) {
            this.minisize *= 4;
        }
        this.MODE = this.MODE_MINITEXT;
    }

    public void putText(int x, int y) {
        if (this.zoomit) {
            x /= this.zoomvalue;
            y /= this.zoomvalue;
            x += this.xoffset;
            y += this.yoffset;
        }
        this.iszoom = this.zoomit;
        this.zoomit = false;
        this.putScreen();
        y /= 2;
        int width = this.minisize;
        if (this.mode == 1) {
            x /= 2;
            width /= 2;
        }
        if (this.mode == 0) {
            x /= 4;
            width /= 4;
        }
        int posx = x;
        for (int i = 0; i < width / 5; ++i) {
            int[] letter = this.minifont.sp;
            if (this.output[i].equals("A")) {
                letter = this.minifont.A;
            }
            if (this.output[i].equals("B")) {
                letter = this.minifont.B;
            }
            if (this.output[i].equals("C")) {
                letter = this.minifont.C;
            }
            if (this.output[i].equals("D")) {
                letter = this.minifont.D;
            }
            if (this.output[i].equals("E")) {
                letter = this.minifont.E;
            }
            if (this.output[i].equals("F")) {
                letter = this.minifont.F;
            }
            if (this.output[i].equals("G")) {
                letter = this.minifont.G;
            }
            if (this.output[i].equals("H")) {
                letter = this.minifont.H;
            }
            if (this.output[i].equals("I")) {
                letter = this.minifont.I;
            }
            if (this.output[i].equals("J")) {
                letter = this.minifont.J;
            }
            if (this.output[i].equals("K")) {
                letter = this.minifont.K;
            }
            if (this.output[i].equals("L")) {
                letter = this.minifont.L;
            }
            if (this.output[i].equals("M")) {
                letter = this.minifont.M;
            }
            if (this.output[i].equals("N")) {
                letter = this.minifont.N;
            }
            if (this.output[i].equals("O")) {
                letter = this.minifont.O;
            }
            if (this.output[i].equals("P")) {
                letter = this.minifont.P;
            }
            if (this.output[i].equals("Q")) {
                letter = this.minifont.Q;
            }
            if (this.output[i].equals("R")) {
                letter = this.minifont.R;
            }
            if (this.output[i].equals("S")) {
                letter = this.minifont.S;
            }
            if (this.output[i].equals("T")) {
                letter = this.minifont.T;
            }
            if (this.output[i].equals("U")) {
                letter = this.minifont.U;
            }
            if (this.output[i].equals("V")) {
                letter = this.minifont.V;
            }
            if (this.output[i].equals("W")) {
                letter = this.minifont.W;
            }
            if (this.output[i].equals("X")) {
                letter = this.minifont.X;
            }
            if (this.output[i].equals("Y")) {
                letter = this.minifont.Y;
            }
            if (this.output[i].equals("Z")) {
                letter = this.minifont.Z;
            }
            if (this.output[i].equals("1")) {
                letter = this.minifont.n1;
            }
            if (this.output[i].equals("2")) {
                letter = this.minifont.n2;
            }
            if (this.output[i].equals("3")) {
                letter = this.minifont.n3;
            }
            if (this.output[i].equals("4")) {
                letter = this.minifont.n4;
            }
            if (this.output[i].equals("5")) {
                letter = this.minifont.n5;
            }
            if (this.output[i].equals("6")) {
                letter = this.minifont.n6;
            }
            if (this.output[i].equals("7")) {
                letter = this.minifont.n7;
            }
            if (this.output[i].equals("8")) {
                letter = this.minifont.n8;
            }
            if (this.output[i].equals("9")) {
                letter = this.minifont.n9;
            }
            if (this.output[i].equals("0")) {
                letter = this.minifont.n0;
            }
            if (this.output[i].equals("\u00a9")) {
                letter = this.minifont.cr;
            }
            if (this.output[i].equals("@")) {
                letter = this.minifont.at;
            }
            if (this.output[i].equals("-")) {
                letter = this.minifont.mn;
            }
            if (this.output[i].equals("+")) {
                letter = this.minifont.pl;
            }
            if (this.output[i].equals(",")) {
                letter = this.minifont.km;
            }
            if (this.output[i].equals(";")) {
                letter = this.minifont.sm;
            }
            if (this.output[i].equals(".")) {
                letter = this.minifont.pt;
            }
            if (this.output[i].equals(":")) {
                letter = this.minifont.dp;
            }
            if (this.output[i].equals("/")) {
                letter = this.minifont.sl;
            }
            if (this.output[i].equals("\\")) {
                letter = this.minifont.bs;
            }
            if (this.output[i].equals("\"")) {
                letter = this.minifont.qt;
            }
            if (this.output[i].equals("?")) {
                letter = this.minifont.qm;
            }
            if (this.output[i].equals("!")) {
                letter = this.minifont.xm;
            }
            if (this.output[i].equals("$")) {
                letter = this.minifont.dl;
            }
            if (this.output[i].equals("&")) {
                letter = this.minifont.nd;
            }
            if (this.output[i].equals("#")) {
                letter = this.minifont.rt;
            }
            if (this.output[i].equals("*")) {
                letter = this.minifont.mp;
            }
            if (this.output[i].equals("_")) {
                letter = this.minifont.us;
            }
            if (this.output[i].equals("(")) {
                letter = this.minifont.bo;
            }
            if (this.output[i].equals(")")) {
                letter = this.minifont.bc;
            }
            if (this.output[i].equals("[")) {
                letter = this.minifont.co;
            }
            if (this.output[i].equals("]")) {
                letter = this.minifont.cc;
            }
            if (this.output[i].equals("=")) {
                letter = this.minifont.eq;
            }
            if (this.output[i].equals("<")) {
                letter = this.minifont.st;
            }
            if (this.output[i].equals(">")) {
                letter = this.minifont.lt;
            }
            if (this.output[i].equals("%")) {
                letter = this.minifont.pc;
            }
            if (this.output[i].equals("|")) {
                letter = this.minifont.rx;
            }
            if (this.output[i].equals("'")) {
                letter = this.minifont.qo;
            }
            if (this.output[i].equals("{")) {
                letter = this.minifont.rc;
            }
            if (this.output[i].equals("}")) {
                letter = this.minifont.ro;
            }
            int block = 0;
            for (int ypixel = 0; ypixel < 5; ++ypixel) {
                for (int xpixel = 0; xpixel < 5; ++xpixel) {
                    if (letter[block] == 1) {
                        this.plot(posx + xpixel, y + ypixel, this.textpen);
                    }
                    if (letter[block] == 2 && this.smoothpen < 16) {
                        this.plot(posx + xpixel, y + ypixel, this.smoothpen);
                    }
                    if (letter[block] == 0 && this.transback < 16) {
                        this.plot(posx + xpixel, y + ypixel, this.transback);
                    }
                    ++block;
                }
            }
            posx += 5;
        }
        this.zoomit = this.iszoom;
        this.putScreen();
    }

    protected int getCOL(Color input) {
        return input.getRGB() & this.mask;
    }

    public void Fill(int x, int y, BufferedImage img, boolean dither) {
        if (this.zoomit) {
            x = x / this.zoomvalue + this.xoffset;
            y = y / this.zoomvalue + this.yoffset;
        }
        this.iszoom = this.zoomit;
        this.zoomit = false;
        int pp = this.pen;
        if (dither && img == null) {
            int cmd = this.commandInt;
            switch (cmd) {
                case 1: {
                    this.dither1 = 0;
                    this.dither2 = 1;
                    break;
                }
                case 2: {
                    this.dither1 = 0;
                    this.dither2 = 2;
                    break;
                }
                case 3: {
                    this.dither1 = 0;
                    this.dither2 = 3;
                    break;
                }
                case 4: {
                    this.dither1 = 1;
                    this.dither2 = 2;
                    break;
                }
                case 5: {
                    this.dither1 = 1;
                    this.dither2 = 3;
                    break;
                }
                case 6: {
                    this.dither1 = 2;
                    this.dither2 = 3;
                    break;
                }
                case 7: {
                    this.dither1 = 0;
                    this.dither2 = 4;
                    break;
                }
                case 8: {
                    this.dither1 = 0;
                    this.dither2 = 5;
                    break;
                }
                case 9: {
                    this.dither1 = 0;
                    this.dither2 = 6;
                    break;
                }
                case 10: {
                    this.dither1 = 0;
                    this.dither2 = 7;
                    break;
                }
                case 11: {
                    this.dither1 = 0;
                    this.dither2 = 8;
                    break;
                }
                case 12: {
                    this.dither1 = 0;
                    this.dither2 = 9;
                    break;
                }
                case 13: {
                    this.dither1 = 0;
                    this.dither2 = 10;
                    break;
                }
                case 14: {
                    this.dither1 = 0;
                    this.dither2 = 11;
                    break;
                }
                case 15: {
                    this.dither1 = 0;
                    this.dither2 = 12;
                    break;
                }
                case 16: {
                    this.dither1 = 0;
                    this.dither2 = 13;
                    break;
                }
                case 17: {
                    this.dither1 = 0;
                    this.dither2 = 14;
                    break;
                }
                case 18: {
                    this.dither1 = 0;
                    this.dither2 = 15;
                    break;
                }
                case 19: {
                    this.dither1 = 1;
                    this.dither2 = 4;
                    break;
                }
                case 20: {
                    this.dither1 = 1;
                    this.dither2 = 5;
                    break;
                }
                case 21: {
                    this.dither1 = 1;
                    this.dither2 = 6;
                    break;
                }
                case 22: {
                    this.dither1 = 1;
                    this.dither2 = 7;
                    break;
                }
                case 23: {
                    this.dither1 = 1;
                    this.dither2 = 8;
                    break;
                }
                case 24: {
                    this.dither1 = 1;
                    this.dither2 = 9;
                    break;
                }
                case 25: {
                    this.dither1 = 1;
                    this.dither2 = 10;
                    break;
                }
                case 26: {
                    this.dither1 = 1;
                    this.dither2 = 11;
                    break;
                }
                case 27: {
                    this.dither1 = 1;
                    this.dither2 = 12;
                    break;
                }
                case 28: {
                    this.dither1 = 1;
                    this.dither2 = 13;
                    break;
                }
                case 29: {
                    this.dither1 = 1;
                    this.dither2 = 14;
                    break;
                }
                case 30: {
                    this.dither1 = 1;
                    this.dither2 = 15;
                    break;
                }
                case 31: {
                    this.dither1 = 2;
                    this.dither2 = 4;
                    break;
                }
                case 32: {
                    this.dither1 = 2;
                    this.dither2 = 5;
                    break;
                }
                case 33: {
                    this.dither1 = 2;
                    this.dither2 = 6;
                    break;
                }
                case 34: {
                    this.dither1 = 2;
                    this.dither2 = 7;
                    break;
                }
                case 35: {
                    this.dither1 = 2;
                    this.dither2 = 8;
                    break;
                }
                case 36: {
                    this.dither1 = 2;
                    this.dither2 = 9;
                    break;
                }
                case 37: {
                    this.dither1 = 2;
                    this.dither2 = 10;
                    break;
                }
                case 38: {
                    this.dither1 = 2;
                    this.dither2 = 11;
                    break;
                }
                case 39: {
                    this.dither1 = 2;
                    this.dither2 = 12;
                    break;
                }
                case 40: {
                    this.dither1 = 2;
                    this.dither2 = 13;
                    break;
                }
                case 41: {
                    this.dither1 = 2;
                    this.dither2 = 14;
                    break;
                }
                case 42: {
                    this.dither1 = 2;
                    this.dither2 = 15;
                    break;
                }
                case 43: {
                    this.dither1 = 3;
                    this.dither2 = 4;
                    break;
                }
                case 44: {
                    this.dither1 = 3;
                    this.dither2 = 5;
                    break;
                }
                case 45: {
                    this.dither1 = 3;
                    this.dither2 = 6;
                    break;
                }
                case 46: {
                    this.dither1 = 3;
                    this.dither2 = 7;
                    break;
                }
                case 47: {
                    this.dither1 = 3;
                    this.dither2 = 8;
                    break;
                }
                case 48: {
                    this.dither1 = 3;
                    this.dither2 = 9;
                    break;
                }
                case 49: {
                    this.dither1 = 3;
                    this.dither2 = 10;
                    break;
                }
                case 50: {
                    this.dither1 = 3;
                    this.dither2 = 11;
                    break;
                }
                case 51: {
                    this.dither1 = 3;
                    this.dither2 = 12;
                    break;
                }
                case 52: {
                    this.dither1 = 3;
                    this.dither2 = 13;
                    break;
                }
                case 53: {
                    this.dither1 = 3;
                    this.dither2 = 14;
                    break;
                }
                case 54: {
                    this.dither1 = 3;
                    this.dither2 = 15;
                    break;
                }
                case 55: {
                    this.dither1 = 4;
                    this.dither2 = 5;
                    break;
                }
                case 56: {
                    this.dither1 = 4;
                    this.dither2 = 6;
                    break;
                }
                case 57: {
                    this.dither1 = 4;
                    this.dither2 = 7;
                    break;
                }
                case 58: {
                    this.dither1 = 4;
                    this.dither2 = 8;
                    break;
                }
                case 59: {
                    this.dither1 = 4;
                    this.dither2 = 9;
                    break;
                }
                case 60: {
                    this.dither1 = 4;
                    this.dither2 = 10;
                    break;
                }
                case 61: {
                    this.dither1 = 4;
                    this.dither2 = 11;
                    break;
                }
                case 62: {
                    this.dither1 = 4;
                    this.dither2 = 12;
                    break;
                }
                case 63: {
                    this.dither1 = 4;
                    this.dither2 = 13;
                    break;
                }
                case 64: {
                    this.dither1 = 4;
                    this.dither2 = 14;
                    break;
                }
                case 65: {
                    this.dither1 = 4;
                    this.dither2 = 15;
                    break;
                }
                case 66: {
                    this.dither1 = 5;
                    this.dither2 = 6;
                    break;
                }
                case 67: {
                    this.dither1 = 5;
                    this.dither2 = 7;
                    break;
                }
                case 68: {
                    this.dither1 = 5;
                    this.dither2 = 8;
                    break;
                }
                case 69: {
                    this.dither1 = 5;
                    this.dither2 = 9;
                    break;
                }
                case 70: {
                    this.dither1 = 5;
                    this.dither2 = 10;
                    break;
                }
                case 71: {
                    this.dither1 = 5;
                    this.dither2 = 11;
                    break;
                }
                case 72: {
                    this.dither1 = 5;
                    this.dither2 = 12;
                    break;
                }
                case 73: {
                    this.dither1 = 5;
                    this.dither2 = 13;
                    break;
                }
                case 74: {
                    this.dither1 = 5;
                    this.dither2 = 14;
                    break;
                }
                case 75: {
                    this.dither1 = 5;
                    this.dither2 = 15;
                    break;
                }
                case 76: {
                    this.dither1 = 6;
                    this.dither2 = 7;
                    break;
                }
                case 77: {
                    this.dither1 = 6;
                    this.dither2 = 8;
                    break;
                }
                case 78: {
                    this.dither1 = 6;
                    this.dither2 = 9;
                    break;
                }
                case 79: {
                    this.dither1 = 6;
                    this.dither2 = 10;
                    break;
                }
                case 80: {
                    this.dither1 = 6;
                    this.dither2 = 11;
                    break;
                }
                case 81: {
                    this.dither1 = 6;
                    this.dither2 = 12;
                    break;
                }
                case 82: {
                    this.dither1 = 6;
                    this.dither2 = 13;
                    break;
                }
                case 83: {
                    this.dither1 = 6;
                    this.dither2 = 14;
                    break;
                }
                case 84: {
                    this.dither1 = 6;
                    this.dither2 = 15;
                    break;
                }
                case 85: {
                    this.dither1 = 7;
                    this.dither2 = 8;
                    break;
                }
                case 86: {
                    this.dither1 = 7;
                    this.dither2 = 9;
                    break;
                }
                case 87: {
                    this.dither1 = 7;
                    this.dither2 = 10;
                    break;
                }
                case 88: {
                    this.dither1 = 7;
                    this.dither2 = 11;
                    break;
                }
                case 89: {
                    this.dither1 = 7;
                    this.dither2 = 12;
                    break;
                }
                case 90: {
                    this.dither1 = 7;
                    this.dither2 = 13;
                    break;
                }
                case 91: {
                    this.dither1 = 7;
                    this.dither2 = 14;
                    break;
                }
                case 92: {
                    this.dither1 = 7;
                    this.dither2 = 15;
                    break;
                }
                case 93: {
                    this.dither1 = 8;
                    this.dither2 = 9;
                    break;
                }
                case 94: {
                    this.dither1 = 8;
                    this.dither2 = 10;
                    break;
                }
                case 95: {
                    this.dither1 = 8;
                    this.dither2 = 11;
                    break;
                }
                case 96: {
                    this.dither1 = 8;
                    this.dither2 = 12;
                    break;
                }
                case 97: {
                    this.dither1 = 8;
                    this.dither2 = 13;
                    break;
                }
                case 98: {
                    this.dither1 = 8;
                    this.dither2 = 14;
                    break;
                }
                case 99: {
                    this.dither1 = 8;
                    this.dither2 = 15;
                    break;
                }
                case 100: {
                    this.dither1 = 9;
                    this.dither2 = 10;
                    break;
                }
                case 101: {
                    this.dither1 = 9;
                    this.dither2 = 11;
                    break;
                }
                case 102: {
                    this.dither1 = 9;
                    this.dither2 = 12;
                    break;
                }
                case 103: {
                    this.dither1 = 9;
                    this.dither2 = 13;
                    break;
                }
                case 104: {
                    this.dither1 = 9;
                    this.dither2 = 14;
                    break;
                }
                case 105: {
                    this.dither1 = 9;
                    this.dither2 = 15;
                    break;
                }
                case 106: {
                    this.dither1 = 10;
                    this.dither2 = 11;
                    break;
                }
                case 107: {
                    this.dither1 = 10;
                    this.dither2 = 12;
                    break;
                }
                case 108: {
                    this.dither1 = 10;
                    this.dither2 = 13;
                    break;
                }
                case 109: {
                    this.dither1 = 10;
                    this.dither2 = 14;
                    break;
                }
                case 110: {
                    this.dither1 = 10;
                    this.dither2 = 15;
                    break;
                }
                case 111: {
                    this.dither1 = 11;
                    this.dither2 = 12;
                    break;
                }
                case 112: {
                    this.dither1 = 11;
                    this.dither2 = 13;
                    break;
                }
                case 113: {
                    this.dither1 = 11;
                    this.dither2 = 14;
                    break;
                }
                case 114: {
                    this.dither1 = 11;
                    this.dither2 = 15;
                    break;
                }
                case 115: {
                    this.dither1 = 12;
                    this.dither2 = 13;
                    break;
                }
                case 116: {
                    this.dither1 = 12;
                    this.dither2 = 14;
                    break;
                }
                case 117: {
                    this.dither1 = 12;
                    this.dither2 = 15;
                    break;
                }
                case 118: {
                    this.dither1 = 13;
                    this.dither2 = 14;
                    break;
                }
                case 119: {
                    this.dither1 = 13;
                    this.dither2 = 15;
                    break;
                }
                case 120: {
                    this.dither1 = 14;
                    this.dither2 = 15;
                    break;
                }
                default: {
                    this.dither1 = this.pen;
                    this.dither2 = this.pen;
                }
            }
            for (int d = 0; d < this.ditherMatrix.length; ++d) {
                this.ditherMatrix[d] = -1;
            }
            this.ditherpos = 0;
            if (this.getCOL(this.test(x, y, null)) == this.getCOL(CPC.getCol(this.dither1))) {
                int dither3 = this.dither1;
                this.dither1 = this.dither2;
                this.dither2 = dither3;
            }
            this.pen = this.dither1;
        }
        filled = 0;
        for (int pf = 0; pf < 800; ++pf) {
            this.yy[pf] = -1;
            this.xx[pf] = -1;
        }
        this.fillX = x;
        this.fillY = y;
        this.xStep = 1;
        this.yStep = 2;
        if (this.mode == 1) {
            this.xStep = 2;
        }
        if (this.mode == 0) {
            this.xStep = 4;
        }
        if (img == null) {
            this.putScreen();
        } else {
            this.xStep = 1;
            this.yStep = 1;
        }
        this.z = 0;
        this.hf = this.test(x, y, img);
        if (green && this.hf == CPC.getGCol(this.pen)) {
            return;
        }
        if (!green && this.getCOL(this.hf) == this.getCOL(CPC.getCol(this.pen))) {
            return;
        }
        this.filling = true;
        this.searchUP(img, dither);
        if (dither && img == null) {
            this.ditherPlot();
        }
        this.pen = pp;
        this.zoomit = this.iszoom;
        this.putScreen();
    }

    void ditherPlot() {
        boolean ap = false;
        for (int d = 0; d < this.ditherMatrix.length; d += 2) {
            if (this.ditherMatrix[d] < 0) continue;
            int x = this.ditherMatrix[d];
            int y = this.ditherMatrix[d + 1];
            ap = x % 2 == 1;
            if (y % 2 == 1) {
                ap = !ap;
            }
            int plot = ap ? this.dither1 : this.dither2;
            this.plot(x, y, plot);
        }
    }

    public void reCalc() {
        --this.z;
        if (this.z >= 0) {
            if (this.xx[this.z] >= 0) {
                this.fillX = this.xx[this.z];
            }
            if (this.yy[this.z] >= 0) {
                this.fillY = this.yy[this.z];
            }
        }
    }

    public void searchUP(BufferedImage img, boolean dither) {
        while (this.z >= 0) {
            Graphics page;
            Graphics graphics = page = img == null ? this.getGraphics() : img.getGraphics();
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            while (this.getCOL(this.test(this.fillX, this.fillY, img)) == this.getCOL(this.hf) && this.fillY < (img == null ? 544 : img.getHeight())) {
                this.fillY += this.yStep;
            }
            this.fillY -= this.yStep;
            this.fr = this.fl = new Color(200, 100, 45);
            while (this.fillY >= 0 && this.getCOL(this.test(this.fillX, this.fillY, img)) == this.getCOL(this.hf) && this.fillX >= 0 && this.fillX <= (img == null ? 768 : img.getWidth()) - this.xStep) {
                this.vfl = this.fl;
                this.fl = this.test(this.fillX - this.xStep, this.fillY, img);
                if (this.getCOL(this.vfl) != this.getCOL(this.hf) && this.getCOL(this.fl) == this.getCOL(this.hf)) {
                    try {
                        if (this.fillX >= this.xStep) {
                            this.xx[this.z] = this.fillX - this.xStep;
                            this.yy[this.z] = this.fillY;
                            ++this.z;
                        } else {
                            this.xx[this.z] = 0;
                            this.yy[this.z] = this.fillY;
                            ++this.z;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        filled = 1;
                        this.filling = false;
                        this.z = -1;
                        break;
                    }
                }
                this.vfr = this.fr;
                this.fr = this.test(this.fillX + this.xStep, this.fillY, img == null ? this.sourceImage : img);
                if (this.getCOL(this.vfr) != this.getCOL(this.hf) && this.getCOL(this.fr) == this.getCOL(this.hf)) {
                    try {
                        this.xx[this.z] = this.fillX + this.xStep;
                        this.yy[this.z] = this.fillY;
                        ++this.z;
                    }
                    catch (Exception e) {
                        filled = 1;
                        this.filling = false;
                        this.z = -1;
                        break;
                    }
                }
                if (img == null) {
                    int cpcY = this.fillY / (img == null ? 2 : 1);
                    int cpcX = this.fillX / (img == null ? this.xStep : 1);
                    if (this.mode == 2) {
                        ++cpcX;
                    }
                    this.plot(cpcX, cpcY, this.pen);
                    if (dither) {
                        this.ditherMatrix[this.ditherpos++] = cpcX;
                        this.ditherMatrix[this.ditherpos++] = cpcY;
                    }
                }
                if (green) {
                    if (img == null) {
                        this.sourceImage.getGraphics().setColor(CPC.getGCol(this.pen));
                    } else {
                        page.setColor(CPC.getGCol(this.pen));
                    }
                } else if (img == null) {
                    this.sourceImage.getGraphics().setColor(CPC.getCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                if (img == null) {
                    this.sourceImage.getGraphics().fillRect(this.fillX, this.fillY, this.xStep, this.yStep);
                } else {
                    page.fillRect(this.fillX, this.fillY, this.xStep, this.yStep);
                    if (dither) {
                        this.ditherMatrix[this.ditherpos++] = this.fillX;
                        this.ditherMatrix[this.ditherpos++] = this.fillY;
                    }
                }
                if (this.showFill && img == null) {
                    page.fillRect(this.fillX, this.fillY, this.xStep, this.yStep);
                }
                this.fillY -= this.yStep;
            }
            this.reCalc();
        }
        filled = 1;
        this.filling = false;
    }

    public Color test(int x, int y, BufferedImage img) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (img == null) {
            img = this.sourceImage;
        }
        if (x >= img.getWidth()) {
            x = img.getWidth() - 1;
        }
        if (y >= img.getHeight()) {
            y = img.getHeight() - 1;
        }
        return new Color(img.getRGB(x, y));
    }

    public Color test(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= 768) {
            x = 767;
        }
        if (y >= 544) {
            y = 543;
        }
        return new Color(this.sourceImage.getRGB(x, y));
    }

    public void buildCPCScreen(BufferedImage image, int[] colorPallet) {
        if (this.dobump) {
            this.bump.filter(image, image);
        }
        if (this.dlevel) {
            this.dither = new DitherFilter();
            this.dither.setLevels(this.ditherlevel);
            this.dither.setColorDither(true);
            this.setMatrixMethod(this.dithermethod);
            this.dither.setMatrix(this.matrix);
            this.dither.filter(image, image);
        }
        this.preRender(image);
        boolean FloydSteinberg = true;
        if (this.rasterval > 118) {
            FloydSteinberg = false;
        }
        int[][] cpComp = new int[colorPallet.length][3];
        for (int k = 0; k < colorPallet.length; ++k) {
            cpComp[k][0] = OverscanCanvas.red(colorPallet[k]);
            cpComp[k][1] = OverscanCanvas.green(colorPallet[k]);
            cpComp[k][2] = OverscanCanvas.blue(colorPallet[k]);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                int pixelR = OverscanCanvas.red(pixel);
                int pixelG = OverscanCanvas.green(pixel);
                int pixelB = OverscanCanvas.blue(pixel);
                int minimumDistance = 195076;
                int ncIndex = -1;
                for (int j = 0; j < colorPallet.length; ++j) {
                    int rDiff = pixelR - cpComp[j][0];
                    int gDiff = pixelG - cpComp[j][1];
                    int bDiff = pixelB - cpComp[j][2];
                    int distance = (int)((double)(rDiff * rDiff) * 0.299 + (double)(gDiff * gDiff) * 0.587 + (double)(bDiff * bDiff) * 0.114);
                    if (distance >= minimumDistance) continue;
                    minimumDistance = distance;
                    ncIndex = j;
                }
                image.setRGB(x, y, colorPallet[ncIndex]);
                if (!FloydSteinberg) continue;
                for (int i = 0; i < 4; ++i) {
                    int yCoor;
                    int xCoor = i == 0 ? x + 1 : (i == 1 ? x - 1 : (i == 2 ? x : x + 1));
                    int n = yCoor = i == 0 ? y : y + 1;
                    if (xCoor < 0 || xCoor >= image.getWidth() || yCoor >= image.getHeight()) continue;
                    double factor = i == 0 ? 7.0 / (double)this.rasterval : (i == 1 ? 3.0 / (double)this.rasterval : (i == 2 ? 5.0 / (double)this.rasterval : 1.0 / (double)this.rasterval));
                    int p = image.getRGB(xCoor, yCoor);
                    int newRed = (int)Math.round((double)OverscanCanvas.red(p) + factor * (double)(pixelR - cpComp[ncIndex][0]));
                    int newGreen = (int)Math.round((double)OverscanCanvas.green(p) + factor * (double)(pixelG - cpComp[ncIndex][1]));
                    int newBlue = (int)Math.round((double)OverscanCanvas.blue(p) + factor * (double)(pixelB - cpComp[ncIndex][2]));
                    if (newRed < 0) {
                        newRed = 0;
                    }
                    if (newRed > 255) {
                        newRed = 255;
                    }
                    if (newGreen < 0) {
                        newGreen = 0;
                    }
                    if (newGreen > 255) {
                        newGreen = 255;
                    }
                    if (newBlue < 0) {
                        newBlue = 0;
                    }
                    if (newBlue > 255) {
                        newBlue = 255;
                    }
                    image.setRGB(xCoor, yCoor, -16777216 + (newRed << 16) + (newGreen << 8) + newBlue);
                }
            }
        }
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public void storeScreen() {
        int i;
        overscanPaint.output.append("Storing screen to " + this.choosenImage + "\n");
        for (i = 0; i < 31936; ++i) {
            this.buffer[this.choosenImage][i] = GateArray.screenmemory[512 + i];
        }
        for (i = 0; i < 16; ++i) {
            this.buffer[this.choosenImage][31936 + i] = (byte)GateArray.getInk(i);
        }
        this.buffer[this.choosenImage][31952] = (byte)this.mode;
        try {
            FileOutputStream out = new FileOutputStream(System.getProperty("user.home") + "/JavaCPC/images_overscan.dat.gz");
            GZIPOutputStream gbos = new GZIPOutputStream(new BufferedOutputStream(out));
            for (int j = 0; j < 20; ++j) {
                gbos.write(this.buffer[j]);
            }
            gbos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadScreens() {
        if (this.screenChanged) {
            try {
                FileInputStream bos = new FileInputStream(System.getProperty("user.home") + "/JavaCPC/images_overscan.dat.gz");
                GZIPInputStream gbos = new GZIPInputStream(new BufferedInputStream(bos));
                this.input = new byte[639064];
                this.count = 0;
                while (gbos.available() != 0) {
                    this.input[this.count] = (byte)gbos.read();
                    ++this.count;
                }
                gbos.close();
                int offset = 0;
                for (int i = 0; i < 20; ++i) {
                    for (int d = 0; d < 31953; ++d) {
                        this.buffer[i][d] = this.input[offset + d];
                    }
                    offset += 31953;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.screenChanged = false;
    }

    public void restoreScreen() {
        int j;
        OverscanCanvas.resetCPCColours();
        overscanPaint.output.append("Re-storing screen from " + this.choosenImage + "\n");
        for (int i = 0; i < 31936; ++i) {
            GateArray.screenmemory[512 + i] = this.buffer[this.choosenImage][i];
        }
        int ad = 2049;
        plusmode = false;
        for (j = ad; j < ad + 32; ++j) {
            if (GateArray.screenmemory[j] == 0) continue;
            plusmode = true;
            break;
        }
        ImageProcessor.plus.setSelected(plusmode);
        if (plusmode) {
            this.makePlus(GateArray.screenmemory, 512);
        }
        for (j = 0; j < 16; ++j) {
            OverscanCanvas.INK(j, this.buffer[this.choosenImage][31936 + j]);
        }
        this.mode = this.buffer[this.choosenImage][31952];
        if (this.mode == 2) {
            CPC.POKE(36863, 2);
        }
        if (this.mode == 1) {
            CPC.POKE(36863, 1);
        }
        if (this.mode == 0) {
            CPC.POKE(36863, 3);
        }
        filled = 1;
        this.doCycle = true;
    }

    static {
        recalculate = 0;
        GateArrayINKs = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11};
        GateArrayColors = new int[]{0, 125, 255, 0x7D0000, 0x7D007D, 8192255, 0xFF0000, 16711805, 0xFF00FF, 32000, 32125, 32255, 0x7D7D00, 0x7D7D7D, 0x7D7DFF, 16743680, 0xFF7D7D, 0xFF7DFF, 65280, 65405, 65535, 8257280, 0x7DFF7D, 0x7DFFFF, 0xFFFF00, 0xFFFF7D, 0xFFFFFF};
        GateArrayOrg = new int[]{0, 125, 255, 0x7D0000, 0x7D007D, 8192255, 0xFF0000, 16711805, 0xFF00FF, 32000, 32125, 32255, 0x7D7D00, 0x7D7D7D, 0x7D7DFF, 16743680, 0xFF7D7D, 0xFF7DFF, 65280, 65405, 65535, 8257280, 0x7DFF7D, 0x7DFFFF, 0xFFFF00, 0xFFFF7D, 0xFFFFFF};
        GateArrayGreens = new int[]{0, 657930, 0x131313, 0x1D1D1D, 0x262626, 0x303030, 0x393939, 0x434343, 0x4C4C4C, 0x575757, 0x606060, 0x6A6A6A, 0x737373, 0x7D7D7D, 0x868686, 0x909090, 0x999999, 0xA3A3A3, 0xACACAC, 0xB5B5B5, 0xBFBFBF, 0xC9C9C9, 0xD2D2D2, 0xDCDCDC, 0xE5E5E5, 0xEFEFEF, 0xF8F8F8};
        horizontal = false;
        ditherBayer4x4Matrix = new int[]{1, 15, 2, 12, 9, 5, 10, 6, 3, 13, 0, 14, 11, 7, 8, 4};
        ditherBayer8x8Matrix = new int[]{0, 48, 12, 60, 3, 51, 15, 63, 32, 16, 44, 28, 35, 19, 47, 31, 8, 56, 4, 52, 11, 59, 7, 55, 40, 24, 36, 20, 43, 27, 39, 23, 2, 50, 14, 62, 1, 49, 13, 61, 34, 18, 46, 30, 33, 17, 45, 29, 10, 58, 6, 54, 9, 57, 5, 53, 42, 26, 38, 22, 41, 25, 37, 21};
        ditherMagic4x4Matrix = new int[]{0, 14, 3, 13, 11, 5, 8, 6, 12, 2, 15, 1, 7, 9, 4, 10};
        ditherOrdered4x4Matrix = new int[]{0, 8, 2, 10, 12, 4, 14, 6, 3, 11, 1, 9, 15, 7, 13, 5};
        ditherLines4x4Matrix = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        dither90Halftone6x6Matrix = new int[]{29, 18, 12, 19, 30, 34, 17, 7, 4, 8, 20, 28, 11, 3, 0, 1, 9, 27, 16, 6, 2, 5, 13, 26, 25, 15, 10, 14, 21, 31, 33, 25, 24, 23, 33, 36};
        ditherOrdered6x6Matrix = new int[]{1, 59, 15, 55, 2, 56, 12, 52, 33, 17, 47, 31, 34, 18, 44, 28, 9, 49, 5, 63, 10, 50, 6, 60, 41, 25, 37, 21, 42, 26, 38, 22, 3, 57, 13, 53, 0, 58, 14, 54, 35, 19, 45, 29, 32, 16, 46, 30, 11, 51, 7, 61, 8, 48, 4, 62, 43, 27, 39, 23, 40, 24, 36, 20};
        ditherOrdered8x8Matrix = new int[]{1, 235, 59, 219, 15, 231, 55, 215, 2, 232, 56, 216, 12, 228, 52, 212, 129, 65, 187, 123, 143, 79, 183, 119, 130, 66, 184, 120, 140, 76, 180, 116, 33, 193, 17, 251, 47, 207, 31, 247, 34, 194, 18, 248, 44, 204, 28, 244, 161, 97, 145, 81, 175, 111, 159, 95, 162, 98, 146, 82, 172, 108, 156, 92, 9, 225, 49, 209, 5, 239, 63, 223, 10, 226, 50, 210, 6, 236, 60, 220, 137, 73, 177, 113, 133, 69, 191, 127, 138, 74, 178, 114, 134, 70, 188, 124, 41, 201, 25, 241, 37, 197, 21, 255, 42, 202, 26, 242, 38, 198, 22, 252, 169, 105, 153, 89, 165, 101, 149, 85, 170, 106, 154, 90, 166, 102, 150, 86, 3, 233, 57, 217, 13, 229, 53, 213, 0, 234, 58, 218, 14, 230, 54, 214, 131, 67, 185, 121, 141, 77, 181, 117, 128, 64, 186, 122, 142, 78, 182, 118, 35, 195, 19, 249, 45, 205, 29, 245, 32, 192, 16, 250, 46, 206, 30, 246, 163, 99, 147, 83, 173, 109, 157, 93, 160, 96, 144, 80, 174, 110, 158, 94, 11, 227, 51, 211, 7, 237, 61, 221, 8, 224, 48, 208, 4, 238, 62, 222, 139, 75, 179, 115, 135, 71, 189, 125, 136, 72, 176, 112, 132, 68, 190, 126, 43, 203, 27, 243, 39, 199, 23, 253, 40, 200, 24, 240, 36, 196, 20, 254, 171, 107, 155, 91, 167, 103, 151, 87, 168, 104, 152, 88, 164, 100, 148, 84};
        ditherCluster3Matrix = new int[]{9, 11, 10, 8, 6, 7, 12, 17, 16, 5, 0, 1, 13, 14, 15, 4, 3, 2, 8, 6, 7, 9, 11, 10, 5, 0, 1, 12, 17, 16, 4, 3, 2, 13, 14, 15};
        ditherCluster4Matrix = new int[]{18, 20, 19, 16, 13, 11, 12, 15, 27, 28, 29, 22, 4, 3, 2, 9, 26, 31, 30, 21, 5, 0, 1, 10, 23, 25, 24, 17, 8, 6, 7, 14, 13, 11, 12, 15, 18, 20, 19, 16, 4, 3, 2, 9, 27, 28, 29, 22, 5, 0, 1, 10, 26, 31, 30, 21, 8, 6, 7, 14, 23, 25, 24, 17};
        ditherCluster8Matrix = new int[]{64, 69, 77, 87, 86, 76, 68, 67, 63, 58, 50, 40, 41, 51, 59, 60, 70, 94, 100, 109, 108, 99, 93, 75, 57, 33, 27, 18, 19, 28, 34, 52, 78, 101, 114, 116, 115, 112, 98, 83, 49, 26, 13, 11, 12, 15, 29, 44, 88, 110, 123, 124, 125, 118, 107, 85, 39, 17, 4, 3, 2, 9, 20, 42, 89, 111, 122, 127, 126, 117, 106, 84, 38, 16, 5, 0, 1, 10, 21, 43, 79, 102, 119, 121, 120, 113, 97, 82, 48, 25, 8, 6, 7, 14, 30, 45, 71, 95, 103, 104, 105, 96, 92, 74, 56, 32, 24, 23, 22, 31, 35, 53, 65, 72, 80, 90, 91, 81, 73, 66, 62, 55, 47, 37, 36, 46, 54, 61, 63, 58, 50, 40, 41, 51, 59, 60, 64, 69, 77, 87, 86, 76, 68, 67, 57, 33, 27, 18, 19, 28, 34, 52, 70, 94, 100, 109, 108, 99, 93, 75, 49, 26, 13, 11, 12, 15, 29, 44, 78, 101, 114, 116, 115, 112, 98, 83, 39, 17, 4, 3, 2, 9, 20, 42, 88, 110, 123, 124, 125, 118, 107, 85, 38, 16, 5, 0, 1, 10, 21, 43, 89, 111, 122, 127, 126, 117, 106, 84, 48, 25, 8, 6, 7, 14, 30, 45, 79, 102, 119, 121, 120, 113, 97, 82, 56, 32, 24, 23, 22, 31, 35, 53, 71, 95, 103, 104, 105, 96, 92, 74, 62, 55, 47, 37, 36, 46, 54, 61, 65, 72, 80, 90, 91, 81, 73, 66};
        autostore = false;
    }
}

